/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.renderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.tools.renderer.Renderer;

public class TextRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog(TextRenderer.class);

    @Override
    public void accept(LogRecord<Record> record) {
        try {
            Record rec = record.message();
            log.info((Object)String.format("|%s|%s|%s|%s|%d|%s|", record.offset(), this.watermarkString(rec.getWatermark()), rec.getFlags(), rec.getKey(), rec.getData().length, this.binaryString(rec.getData())));
        }
        catch (ClassCastException e) {
            log.info((Object)String.format("%s", record.message()));
        }
    }

    @Override
    public void header() {
        log.info((Object)"| offset | watermark | flag | key | length | data |\n| --- | --- | --- | --- | ---: | --- |");
    }

    @Override
    public void footer() {
        log.info((Object)"");
    }
}

