/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.codec;

import avro.shaded.com.google.common.collect.MapMaker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.AvroSchemaStore;

public class FileAvroSchemaStore
implements AvroSchemaStore {
    private static final Log log = LogFactory.getLog(FileAvroSchemaStore.class);
    protected static final String AVRO_SCHEMA_EXT = ".avsc";
    protected final Path schemaDirectoryPath;
    protected final Map<Long, Schema> schemas = new MapMaker().makeMap();

    public FileAvroSchemaStore(Path schemaDirectoryPath) {
        this.schemaDirectoryPath = schemaDirectoryPath;
        File directory = schemaDirectoryPath.toFile();
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException("Invalid SchemaStore root path: " + schemaDirectoryPath);
            }
            this.loadSchemas(schemaDirectoryPath);
        } else {
            directory.mkdirs();
        }
    }

    public void loadSchemas(Path directory) {
        try (Stream<Path> paths = Files.list(directory);){
            paths.filter(path -> Files.isReadable(path) && path.getFileName().toString().endsWith(AVRO_SCHEMA_EXT)).forEach(this::loadSchema);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid base path: " + directory, e);
        }
    }

    public void loadSchema(Path schemaPath) {
        try {
            Schema schema = new Schema.Parser().parse(schemaPath.toFile());
            this.addSchema(schema);
        }
        catch (IOException e) {
            log.error((Object)("Invalid schema file: " + schemaPath), (Throwable)e);
        }
    }

    @Override
    public long addSchema(Schema schema) {
        long fp = SchemaNormalization.parsingFingerprint64((Schema)schema);
        if (this.schemas.put(fp, schema) == null) {
            Path schemaPath = this.schemaDirectoryPath.resolve(String.format("%s-0x%08X%s", schema.getName(), fp, AVRO_SCHEMA_EXT));
            try (PrintWriter out = new PrintWriter(schemaPath.toFile());){
                out.println(schema.toString(true));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot write schema to file: " + schemaPath);
            }
        }
        return fp;
    }

    public Schema findByFingerprint(long fingerprint) {
        return this.schemas.get(fingerprint);
    }
}

