/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.nuxeo.lib.stream.codec.Codec;

public class SerializableCodec<T extends Serializable>
implements Codec<T> {
    public static final String NAME = "java";

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encode(T object) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(object);
                out.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T decode(byte[] data) {
        Serializable serializable;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            serializable = (Serializable)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                bis.close();
            }
            catch (IOException iOException) {}
        }
        return (T)serializable;
    }
}

