/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.tools.CommandRegistry;
import org.nuxeo.lib.stream.tools.command.Command;

public class HelpCommand
extends Command {
    protected static final String NAME = "help";
    protected Options options;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        this.options = options;
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) {
        List<Command> commands = new CommandRegistry().commands();
        this.displayCommonOptions();
        if (cmd.getArgList().isEmpty()) {
            commands.stream().filter(command -> !(command instanceof HelpCommand)).forEach(this::displayHelp);
        } else {
            String name = (String)cmd.getArgList().get(0);
            commands.stream().filter(command -> name.equals(command.name())).forEach(this::displayHelp);
        }
        return true;
    }

    protected void displayCommonOptions() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("");
        formatter.printHelp("Usage: stream.sh [COMMAND] [Options]\nCommon options:", this.options);
    }

    protected void displayHelp(Command command) {
        Options cmdOptions = new Options();
        command.updateOptions(cmdOptions);
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("Command: ");
        formatter.printHelp(command.name(), cmdOptions);
    }
}

