/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ComputationMetadata {
    protected final String name;
    protected final Set<String> inputStreams;
    protected final Set<String> outputStreams;

    public ComputationMetadata(String name, Set<String> inputStreams, Set<String> outputStreams) {
        this.name = Objects.requireNonNull(name);
        this.inputStreams = inputStreams == null ? Collections.emptySet() : inputStreams;
        this.outputStreams = outputStreams == null ? Collections.emptySet() : outputStreams;
        if (this.inputStreams.isEmpty() && this.outputStreams.isEmpty()) {
            throw new IllegalArgumentException("Both input and output streams are empty");
        }
    }

    public String name() {
        return this.name;
    }

    public Set<String> inputStreams() {
        return this.inputStreams;
    }

    public Set<String> outputStreams() {
        return this.outputStreams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputationMetadata metadata = (ComputationMetadata)o;
        return this.name.equals(metadata.name) && this.inputStreams.equals(metadata.inputStreams) && this.outputStreams.equals(metadata.outputStreams);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.inputStreams.hashCode();
        result = 31 * result + this.outputStreams.hashCode();
        return result;
    }

    public String toString() {
        return "ComputationMetadata{name=" + this.name + ", inputStreams=" + this.inputStreams + ", outputStreams=" + this.outputStreams + "}";
    }
}

