/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.tools.command.Command;

public class LatencyCommand
extends Command {
    private static final Log log = LogFactory.getLog(LatencyCommand.class);
    protected static final String NAME = "latency";
    protected boolean verbose = false;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name of a stream containing computation.Record").hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder().longOpt("codec").desc("Codec used to read record, can be: java, avro, avroBinary, avroJson").hasArg().argName("CODEC").build());
        options.addOption(Option.builder().longOpt("verbose").desc("Display latency for each partition").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) {
        String logName = cmd.getOptionValue("log-name");
        Codec<Record> codec = this.getRecordCodec(cmd.getOptionValue("codec"));
        this.verbose = cmd.hasOption("verbose");
        if (logName != null) {
            this.latency(manager, Name.ofUrn(logName), codec);
        } else {
            this.latency(manager, codec);
        }
        return true;
    }

    protected void latency(LogManager manager, Codec<Record> codec) {
        log.info((Object)("# " + manager));
        for (Name name : manager.listAllNames()) {
            this.latency(manager, name, codec);
        }
    }

    protected void latency(LogManager manager, Name name, Codec<Record> codec) {
        log.info((Object)("## Log: " + name + " partitions: " + manager.size(name)));
        List<Name> consumers = manager.listConsumerGroups(name);
        if (this.verbose && consumers.isEmpty()) {
            consumers.add(Name.ofUrn("admin/tools"));
        }
        try {
            consumers.forEach(group -> this.renderLatency((Name)group, manager.getLatencyPerPartition(name, (Name)group, codec, rec -> Watermark.ofValue(rec.getWatermark()).getTimestamp(), Record::getKey)));
        }
        catch (IllegalStateException e) {
            log.error((Object)e.getMessage());
        }
    }

    protected void renderLatency(Name group, List<Latency> latencies) {
        log.info((Object)String.format("### Group: %s", group));
        log.info((Object)"| partition | lag | latencyMs | latency | posTimestamp | posDate | curDate | pos | end | posOffset |\u00a0endOffset\u00a0| posKey |\n| --- | ---: | ---: | ---: | ---: | ---: | ---: | ---: | ---: | ---: | ---: | --- |");
        Latency all = Latency.of(latencies);
        log.info((Object)String.format("|All|%d|%d|%s|%d|%s|%s|%d|%d|%d|%d|%s|", all.lag().lag(), all.latency(), LatencyCommand.formatInterval(all.latency()), all.lower(), this.formatDate(all.lower()), this.formatDate(all.upper()), all.lag().lower(), all.lag().upper(), all.lag().lowerOffset(), all.lag().upperOffset(), all.key()));
        if (this.verbose && latencies.size() > 1) {
            AtomicInteger i = new AtomicInteger();
            latencies.forEach(lat -> log.info((Object)String.format("|%d|%d|%d|%s|%d|%s|%s|%d|%d|%d|%d|%s|", i.getAndIncrement(), lat.lag().lag(), lat.latency(), LatencyCommand.formatInterval(lat.latency()), lat.lower(), this.formatDate(lat.lower()), this.formatDate(lat.upper()), lat.lag().lower(), lat.lag().upper(), lat.lag().lowerOffset(), lat.lag().upperOffset(), lat.key())));
        }
    }

    protected String formatDate(long timestamp) {
        if (timestamp > 0L) {
            return Instant.ofEpochMilli(timestamp).toString();
        }
        return "NA";
    }

    protected static String formatInterval(long l) {
        if (l == 0L) {
            return "NA";
        }
        long hr = TimeUnit.MILLISECONDS.toHours(l);
        long min = TimeUnit.MILLISECONDS.toMinutes(l - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        long ms = TimeUnit.MILLISECONDS.toMillis(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min) - TimeUnit.SECONDS.toMillis(sec));
        return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
    }
}

