/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.liveedit.extension.ooo;

import com.sun.star.beans.NamedValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.task.XJob;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseListener;
import com.sun.star.util.XCloseable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nuxeo.liveedit.ActionItem;
import org.nuxeo.liveedit.DocumentFileItem;
import org.nuxeo.liveedit.restclient.LiveEditClientRestletImpl;

public final class LiveEditConnector
extends WeakBase
implements XServiceInfo,
XJob,
XCloseable {
    Logger log = Logger.getLogger(LiveEditConnector.class);
    private final XComponentContext m_xContext;
    private static final String m_implementationName = LiveEditConnector.class.getName();
    private static final String[] m_serviceNames = new String[]{"org.nuxeo.liveedit.extension.ooo"};
    private static Map<String, ActionItem> actionItemRepositoryByURL = new HashMap<String, ActionItem>();
    private static Map<String, ActionItem> actionItemRepositoryByID = new HashMap<String, ActionItem>();
    private static Map<String, DocumentFileItem[]> locationsByURL = new HashMap<String, DocumentFileItem[]>();
    private static Map<String, DocumentFileItem[]> locationsByID = new HashMap<String, DocumentFileItem[]>();
    private static Map<String, String> oooDocumentType = new HashMap<String, String>();
    private static Map<String, String> oooFilterNames = new HashMap<String, String>();

    public LiveEditConnector(XComponentContext context) {
        oooDocumentType.put("application/msword", "private:factory/swriter");
        oooDocumentType.put("application/vnd.ms-excel", "private:factory/scalc");
        oooDocumentType.put("application/vnd.ms-powerpoint", "private:factory/simpress");
        oooDocumentType.put("application/vnd.oasis.opendocument.spreadsheet", "private:factory/scalc");
        oooDocumentType.put("application/vnd.oasis.opendocument.text", "private:factory/swriter");
        oooDocumentType.put("application/vnd.oasis.opendocument.presentation", "private:factory/simpress");
        oooDocumentType.put("application/vnd.oasis.opendocument.graphics", "private:factory/sdraw");
        oooDocumentType.put("application/vnd.oasis.opendocument.graphics-template", "private:factory/sdraw");
        oooDocumentType.put("application/vnd.oasis.opendocument.presentation-template", "private:factory/simpress");
        oooDocumentType.put("application/vnd.oasis.opendocument.text-template", "private:factory/swriter");
        oooDocumentType.put("application/vnd.oasis.opendocument.spreadsheet-template", "private:factory/scalc");
        oooDocumentType.put("application/vnd.sun.xml.draw.template", "private:factory/sdraw");
        oooDocumentType.put("application/vnd.sun.xml.draw", "private:factory/sdraw");
        oooDocumentType.put("application/vnd.sun.xml.calc.template", "private:factory/scalc");
        oooDocumentType.put("application/vnd.sun.xml.calc", "private:factory/scalc");
        oooDocumentType.put("application/vnd.sun.xml.impress.template", "private:factory/simpress");
        oooDocumentType.put("application/vnd.sun.xml.impress", "private:factory/simpress");
        oooDocumentType.put("application/vnd.sun.xml.writer.template", "private:factory/swriter");
        oooDocumentType.put("application/vnd.sun.xml.writer", "private:factory/swriter");
        oooFilterNames.put("application/msword", "MS Word 97");
        oooFilterNames.put("application/vnd.ms-excel", "MS Excel 97");
        oooFilterNames.put("application/vnd.ms-powerpoint", "MS PowerPoint 97");
        oooFilterNames.put("application/vnd.oasis.opendocument.spreadsheet", "calc8");
        oooFilterNames.put("application/vnd.oasis.opendocument.text", "writer8");
        oooFilterNames.put("application/vnd.oasis.opendocument.presentation", "impress8");
        oooFilterNames.put("application/vnd.oasis.opendocument.graphics", "draw8");
        oooFilterNames.put("application/vnd.oasis.opendocument.graphics-template", "draw8");
        oooFilterNames.put("application/vnd.oasis.opendocument.presentation-template", "impress8");
        oooFilterNames.put("application/vnd.oasis.opendocument.text-template", "writer8");
        oooFilterNames.put("application/vnd.oasis.opendocument.spreadsheet-template", "calc8");
        oooFilterNames.put("application/vnd.sun.xml.draw.template", "StarOffice XML (Draw)");
        oooFilterNames.put("application/vnd.sun.xml.draw", "StarOffice XML (Draw)");
        oooFilterNames.put("application/vnd.sun.xml.calc.template", "StarOffice XML (Calc)");
        oooFilterNames.put("application/vnd.sun.xml.calc", "StarOffice XML (Calc)");
        oooFilterNames.put("application/vnd.sun.xml.impress.template", "StarOffice XML (Impress)");
        oooFilterNames.put("application/vnd.sun.xml.impress", "StarOffice XML (Impress)");
        oooFilterNames.put("application/vnd.sun.xml.writer.template", "StarOffice XML (Writer)");
        oooFilterNames.put("application/vnd.sun.xml.writer", "StarOffice XML (Writer)");
        this.m_xContext = context;
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplementationName) {
        XSingleComponentFactory xFactory = null;
        if (sImplementationName.equals(m_implementationName)) {
            xFactory = Factory.createComponentFactory(LiveEditConnector.class, (String[])m_serviceNames);
        }
        return xFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        return Factory.writeRegistryServiceInfo((String)m_implementationName, (String[])m_serviceNames, (XRegistryKey)xRegistryKey);
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public Object execute(NamedValue[] Arguments) throws IllegalArgumentException, com.sun.star.uno.Exception {
        NamedValue action = this.getArgumentByName("action", Arguments);
        String actionValue = (String)action.Value;
        this.log.debug((Object)("Action : " + actionValue));
        Object success = false;
        if (actionValue.equals("lock")) {
            success = this.actionLock(Arguments);
        } else if (actionValue.equals("unlock")) {
            success = this.actionUnlock(Arguments);
        }
        if (actionValue.equals("load")) {
            success = this.actionLoad(Arguments);
        }
        if (actionValue.equals("edit")) {
            success = this.actionEdit(Arguments);
        }
        if (actionValue.equals("create")) {
            success = this.actionCreate(Arguments);
        }
        if (actionValue.equals("getActionValue")) {
            success = this.getActionValue(Arguments);
        }
        if (actionValue.equals("getLocations")) {
            success = this.getLocations(Arguments);
        }
        if (actionValue.equals("getMimeType")) {
            success = this.getMimeType(Arguments);
        }
        if (actionValue.equals("getExtension")) {
            success = this.getExtension(Arguments);
        }
        if (actionValue.equals("getOOoDocumentFactory")) {
            success = this.getOOoDocumentFactory(Arguments);
        }
        if (actionValue.equals("getOOoFilterName")) {
            success = this.getOOoFilterName(Arguments);
        }
        this.log.debug((Object)("Value returned by service :" + success));
        this.log.debug((Object)"_________________________________________");
        this.log.debug(Thread.getAllStackTraces());
        this.log.debug((Object)"_________________________________________");
        return success;
    }

    private NamedValue getArgumentByName(String name, NamedValue[] Arguments) {
        for (NamedValue arg : Arguments) {
            if (!arg.Name.equals(name)) continue;
            return arg;
        }
        return new NamedValue();
    }

    public void addCloseListener(XCloseListener Listener) {
    }

    public void removeCloseListener(XCloseListener Listener) {
    }

    public void close(boolean DeliverOwnership) throws CloseVetoException {
    }

    private String actionLoad(NamedValue[] Arguments) {
        String xmlFileAction = (String)this.getArgumentByName((String)"filename", (NamedValue[])Arguments).Value;
        this.log.debug((Object)("Load XMLFile : " + xmlFileAction));
        LiveEditClientRestletImpl clientRestlet = new LiveEditClientRestletImpl();
        ActionItem action = clientRestlet.loadFileItemXml(xmlFileAction);
        this.log.debug((Object)("DocumentModelId : " + action.getDocument().getDocRef()));
        String downloadedFileURL = "";
        try {
            DocumentFileItem document = null;
            this.log.debug((Object)("Action selector : " + action.getActionSelector()));
            document = action.getActionSelector().equals("createFromTemplate") ? action.getTemplate() : action.getDocument();
            this.log.debug((Object)("DocumentModel repo/docRef : " + document.getRepository() + "/" + document.getDocRef()));
            downloadedFileURL = clientRestlet.downloadDocumentFileToFile(action, document);
            this.log.debug((Object)("Doc uploaded url : " + downloadedFileURL));
            ArrayList<NamedValue> reponse = new ArrayList<NamedValue>();
            NamedValue url = new NamedValue();
            url.Name = "fileURL";
            url.Value = downloadedFileURL;
            reponse.add(url);
            NamedValue docId = new NamedValue();
            docId.Name = "docId";
            docId.Value = action.getEditId();
            reponse.add(docId);
            actionItemRepositoryByURL.put(downloadedFileURL, action);
            actionItemRepositoryByID.put(action.getEditId(), action);
        }
        catch (Exception e) {
            System.out.println("File not downloaded " + e.getMessage());
        }
        return downloadedFileURL;
    }

    private String getActionValue(NamedValue[] Arguments) {
        ActionItem actionItem = this.getActionItem(Arguments);
        String selector = "";
        if (actionItem != null) {
            selector = actionItem.getActionSelector();
        }
        return selector;
    }

    private String actionEdit(NamedValue[] Arguments) {
        ActionItem actionItem = this.getActionItem(Arguments);
        String url = (String)this.getArgumentByName((String)"url", (NamedValue[])Arguments).Value;
        LiveEditClientRestletImpl clientRestlet = new LiveEditClientRestletImpl();
        DocumentFileItem document = null;
        document = actionItem.getActionSelector().equals("createFromTemplate") ? actionItem.getTemplate() : actionItem.getDocument();
        String versioning = (String)this.getArgumentByName((String)"versioning", (NamedValue[])Arguments).Value;
        clientRestlet.uploadDocumentFile(url, actionItem, document, versioning);
        String success = "Edit action is Ok";
        return success;
    }

    private String getMimeType(NamedValue[] Arguments) {
        return this.getActionItem(Arguments).getDocument().getMimetype();
    }

    private String getOOoDocumentFactory(NamedValue[] Arguments) {
        String mimetype = this.getMimeType(Arguments);
        String factory = "private:factory/swriter";
        if (oooDocumentType.containsKey(mimetype)) {
            factory = oooDocumentType.get(mimetype);
        }
        return factory;
    }

    private String getOOoFilterName(NamedValue[] Arguments) {
        String mimetype = this.getMimeType(Arguments);
        String filtername = "writer8";
        if (oooFilterNames.containsKey(mimetype)) {
            filtername = oooFilterNames.get(mimetype);
        }
        return filtername;
    }

    private String getExtension(NamedValue[] Arguments) {
        return this.getActionItem(Arguments).getDocument().getFileExtension();
    }

    private String[] getLocations(NamedValue[] Arguments) {
        String url = (String)this.getArgumentByName((String)"url", (NamedValue[])Arguments).Value;
        ActionItem actionItem = actionItemRepositoryByURL.get(url);
        LiveEditClientRestletImpl clientRestlet = new LiveEditClientRestletImpl();
        DocumentFileItem[] locations = clientRestlet.getLocations(actionItem);
        locationsByURL.put(url, locations);
        String[] locationList = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            String label;
            DocumentFileItem fileItem = locations[i];
            locationList[i] = label = fileItem.getDocTitle() + " " + fileItem.getDocPath();
        }
        return locationList;
    }

    private Boolean actionCreate(NamedValue[] Arguments) {
        String url = (String)this.getArgumentByName((String)"url", (NamedValue[])Arguments).Value;
        ActionItem actionItem = actionItemRepositoryByURL.get(url);
        DocumentFileItem[] documents = locationsByURL.get(url);
        String filename = (String)this.getArgumentByName((String)"filename", (NamedValue[])Arguments).Value;
        String title = (String)this.getArgumentByName((String)"title", (NamedValue[])Arguments).Value;
        String description = (String)this.getArgumentByName((String)"description", (NamedValue[])Arguments).Value;
        Integer locationIndex = Integer.valueOf((String)this.getArgumentByName((String)"locationIndex", (NamedValue[])Arguments).Value);
        System.out.println("filename " + filename);
        System.out.println("title " + title);
        DocumentFileItem fileItem = documents[locationIndex];
        LiveEditClientRestletImpl clientRestlet = new LiveEditClientRestletImpl();
        DocumentFileItem createdDocument = clientRestlet.createDocument(actionItem, fileItem, title, description, filename);
        actionItem.setDocument(createdDocument);
        actionItem.setActionSelector("edit");
        actionItemRepositoryByURL.put(url, actionItem);
        clientRestlet.uploadDocumentFile(url, actionItem, actionItem.getDocument());
        return true;
    }

    private Boolean actionLock(NamedValue[] Arguments) {
        ActionItem actionItem = this.getActionItem(Arguments);
        DocumentFileItem document = null;
        if (actionItem.getActionSelector().equals("createFromTemplate")) {
            document = actionItem.getTemplate();
            this.log.debug((Object)"--createFromTemplate--");
        } else {
            document = actionItem.getDocument();
            this.log.debug((Object)"--other--");
        }
        this.log.debug((Object)("Action lock : " + document.getDocRef() + "/" + document.getRepository()));
        LiveEditClientRestletImpl clientRestlet = new LiveEditClientRestletImpl();
        boolean result = clientRestlet.lockDocument(actionItem, document);
        return result;
    }

    private Boolean actionUnlock(NamedValue[] Arguments) {
        ActionItem actionItem = this.getActionItem(Arguments);
        DocumentFileItem document = null;
        if (actionItem.getActionSelector().equals("createFromTemplate")) {
            document = actionItem.getTemplate();
            this.log.debug((Object)"--createFromTemplate--");
        } else {
            document = actionItem.getDocument();
            this.log.debug((Object)"--other--");
        }
        this.log.debug((Object)("Action Unlock : " + document.getDocRef() + "/" + document.getRepository()));
        LiveEditClientRestletImpl clientRestlet = new LiveEditClientRestletImpl();
        boolean result = clientRestlet.unlockDocument(actionItem, document);
        return true;
    }

    private ActionItem getActionItem(NamedValue[] Arguments) {
        String url = (String)this.getArgumentByName((String)"url", (NamedValue[])Arguments).Value;
        this.log.debug((Object)("URL file found in the context : " + url));
        ActionItem actionItem = actionItemRepositoryByURL.get(url);
        this.log.debug((Object)("Action Item found in the context : " + actionItem));
        return actionItem;
    }
}

