/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;

public class ThemesTable
extends POIXMLDocumentPart {
    private ThemeDocument theme;

    public ThemesTable(PackagePart part, PackageRelationship rel) throws Exception {
        super(part, rel);
        this.theme = ThemeDocument.Factory.parse(part.getInputStream());
    }

    public ThemesTable(ThemeDocument theme) {
        this.theme = theme;
    }

    public XSSFColor getThemeColor(int idx) {
        CTColorScheme colorScheme = this.theme.getTheme().getThemeElements().getClrScheme();
        CTColor ctColor = null;
        int cnt = 0;
        for (XmlObject obj : colorScheme.selectPath("./*")) {
            if (!(obj instanceof CTColor)) continue;
            if (cnt == idx) {
                ctColor = (CTColor)obj;
                return new XSSFColor(ctColor.getSrgbClr().getVal());
            }
            ++cnt;
        }
        return null;
    }
}

