/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectUtil;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.OneKeySelection;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.DataType;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IComparableStructure;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;
import org.eclipse.birt.data.engine.olap.data.util.NodeSelection;
import org.eclipse.birt.data.engine.olap.data.util.NonLeafNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskIndex {
    private static final int VERSION = 10000;
    private String name;
    private int degree;
    private IDocumentObject documentObject = null;
    private IDocumentObject offsetDocumentObject = null;
    private IDocumentManager documentManager = null;
    private int[] keyDataType;
    private int keyCount;
    private int rootNodeOffset;
    private int numberOfLevel;
    private int currentVersion = 1;

    public static DiskIndex createIndex(IDocumentManager documentManager, String name, int sonNumber, IDiskArray keyList, boolean isSorted) throws IOException, DataException {
        assert (sonNumber <= 127);
        assert (keyList.size() > 0);
        DiskIndex indexTree = new DiskIndex(documentManager, name, sonNumber, keyList, isSorted);
        return indexTree;
    }

    public static DiskIndex createIndex(IDocumentManager documentManager, String name, IDiskArray keyList, boolean isSorted) throws IOException, DataException {
        return DiskIndex.createIndex(documentManager, name, 3, keyList, isSorted);
    }

    public static DiskIndex loadIndex(IDocumentManager documentManager, String name) throws IOException, DataException {
        return new DiskIndex(documentManager, name);
    }

    DiskIndex(IDocumentManager documentManager, String name, int granularity, IDiskArray keyList, boolean isSorted) throws IOException, DataException {
        this.name = name;
        this.degree = granularity;
        this.documentManager = documentManager;
        this.produce(keyList, isSorted);
    }

    DiskIndex(IDocumentManager documentManager, String name) throws IOException, DataException {
        this.name = name;
        this.documentManager = documentManager;
        this.loadFromDisk();
    }

    public String getName() {
        return this.name;
    }

    private void loadFromDisk() throws IOException, DataException {
        this.openReadDocumentObject();
        this.keyDataType = new int[this.documentObject.readInt()];
        int i = 0;
        while (i < this.keyDataType.length) {
            this.keyDataType[i] = this.documentObject.readInt();
            ++i;
        }
        this.keyCount = this.documentObject.readInt();
        this.degree = this.documentObject.readInt();
        this.currentVersion = this.degree > 10000 ? this.degree / 10000 : 0;
        this.rootNodeOffset = this.documentObject.readInt();
        this.numberOfLevel = this.documentObject.readShort();
        if (this.numberOfLevel < 1 || this.numberOfLevel > 1000 || Math.pow(this.degree, this.numberOfLevel) < (double)this.keyCount) {
            throw new DataException("data.olap.OlapFileFormatError", this.name);
        }
    }

    private static String getOffsetDocName(String name) {
        return String.valueOf(name) + "_offset";
    }

    private void produce(IDiskArray keyList, boolean isSorted) throws IOException, DataException {
        this.createDocumentObject();
        if (keyList.size() == 0) {
            return;
        }
        IndexKey indexKey = (IndexKey)keyList.get(0);
        this.keyDataType = new int[indexKey.getKey().length];
        int i = 0;
        while (i < indexKey.getKey().length) {
            this.keyDataType[i] = DataType.getDataType(((IndexKey)keyList.get(0)).getKey()[i].getClass());
            ++i;
        }
        IDiskArray sortedKeyArray = null;
        sortedKeyArray = !isSorted ? this.sortKeys(keyList) : keyList;
        this.keyCount = sortedKeyArray.size();
        int rootOffsetPos = this.saveIndexHeader() - 6;
        IDiskArray sonStartOffset = this.writeLeafNode(sortedKeyArray, this.degree);
        this.numberOfLevel = 1;
        int sonLevelTotalNumber = sortedKeyArray.size();
        int lastLevelTotalNumber = 0;
        while (sonStartOffset != null && sonStartOffset.size() > 1) {
            lastLevelTotalNumber = sonStartOffset.size();
            sonStartOffset = this.writeNonLeafNode(sortedKeyArray, sonStartOffset, this.numberOfLevel, sonLevelTotalNumber);
            ++this.numberOfLevel;
            sonLevelTotalNumber = lastLevelTotalNumber;
        }
        assert (sonStartOffset.size() == 1);
        sonStartOffset = this.writeNonLeafNode(sortedKeyArray, sonStartOffset, this.numberOfLevel, sonLevelTotalNumber);
        this.rootNodeOffset = (Integer)sonStartOffset.get(0);
        this.documentObject.seek(rootOffsetPos);
        this.documentObject.writeInt(this.rootNodeOffset);
        this.documentObject.writeShort(this.numberOfLevel);
        this.documentObject.flush();
        this.offsetDocumentObject.flush();
        this.closeWriteDocumentObject();
        this.openReadDocumentObject();
    }

    private void closeWriteDocumentObject() throws IOException {
        if (this.documentObject != null) {
            this.documentObject.close();
            this.documentObject = null;
        }
        if (this.offsetDocumentObject != null) {
            this.offsetDocumentObject.close();
            this.offsetDocumentObject = null;
        }
    }

    private void openReadDocumentObject() throws IOException {
        if (this.documentObject == null) {
            this.documentObject = this.documentManager.openDocumentObject(this.name);
            this.documentObject.seek(0L);
        }
        if (this.offsetDocumentObject == null) {
            this.offsetDocumentObject = this.documentManager.openDocumentObject(DiskIndex.getOffsetDocName(this.name));
            this.documentObject.seek(0L);
        }
    }

    private int saveIndexHeader() throws IOException {
        this.documentObject.writeInt(this.keyDataType.length);
        int i = 0;
        while (i < this.keyDataType.length) {
            this.documentObject.writeInt(this.keyDataType[i]);
            ++i;
        }
        this.documentObject.writeInt(this.keyCount);
        this.documentObject.writeInt(this.degree + 10000);
        byte[] b = new byte[6];
        this.documentObject.write(b, 0, 6);
        return (int)this.documentObject.getFilePointer();
    }

    private IDiskArray writeLeafNode(IDiskArray sortedKeyArray, int interval) throws IOException, DataException {
        BufferedPrimitiveDiskArray offset = new BufferedPrimitiveDiskArray(Math.min(sortedKeyArray.size(), Constants.MAX_LIST_BUFFER_SIZE));
        int i = 0;
        while (i < sortedKeyArray.size()) {
            if (i % interval == 0) {
                offset.add((int)this.documentObject.getFilePointer());
            }
            this.offsetDocumentObject.writeInt((int)this.documentObject.getFilePointer());
            this.writeKeyObject((IndexKey)sortedKeyArray.get(i));
            ++i;
        }
        return offset;
    }

    private IDiskArray writeNonLeafNode(IDiskArray sortedKeyArray, IDiskArray startOffset, int level, int sonLevelTotalNumber) throws IOException, DataException {
        int interval = this.pow(this.degree, level);
        BufferedPrimitiveDiskArray sonStartOffset = new BufferedPrimitiveDiskArray(Math.min(Constants.MAX_LIST_BUFFER_SIZE, startOffset.size() / this.degree + 1));
        int i = 0;
        while (i < startOffset.size()) {
            if (i % this.degree == 0) {
                sonStartOffset.add((int)this.documentObject.getFilePointer());
            }
            if (i != startOffset.size() - 1) {
                this.documentObject.writeByte(this.degree);
                DocumentObjectUtil.writeValue(this.documentObject, this.keyDataType, ((IndexKey)sortedKeyArray.get(i * interval)).getKey());
                DocumentObjectUtil.writeValue(this.documentObject, this.keyDataType, ((IndexKey)sortedKeyArray.get((i + 1) * interval - 1)).getKey());
            } else {
                this.documentObject.writeByte(sonLevelTotalNumber - (startOffset.size() - 1) * this.degree);
                DocumentObjectUtil.writeValue(this.documentObject, this.keyDataType, ((IndexKey)sortedKeyArray.get(i * interval)).getKey());
                DocumentObjectUtil.writeValue(this.documentObject, this.keyDataType, ((IndexKey)sortedKeyArray.get(sortedKeyArray.size() - 1)).getKey());
            }
            this.documentObject.writeInt((Integer)startOffset.get(i));
            ++i;
        }
        return sonStartOffset;
    }

    private int pow(int a, int b) {
        int reValue = a;
        int i = 0;
        while (i < b - 1) {
            reValue *= a;
            ++i;
        }
        return reValue;
    }

    private void writeKeyObject(IndexKey keyObject) throws IOException, DataException {
        this.documentObject.writeInt(keyObject.getDimensionPos().length);
        int i = 0;
        while (i < keyObject.getDimensionPos().length) {
            this.documentObject.writeInt(keyObject.getDimensionPos()[i]);
            ++i;
        }
        i = 0;
        while (i < this.keyDataType.length) {
            DocumentObjectUtil.writeValue(this.documentObject, this.keyDataType[i], keyObject.getKey()[i]);
            ++i;
        }
        this.documentObject.writeInt(keyObject.getOffset().length);
        i = 0;
        while (i < keyObject.getOffset().length) {
            this.documentObject.writeInt(keyObject.getOffset()[i]);
            ++i;
        }
    }

    private NonLeafNode readNonLeafNode() throws IOException {
        NonLeafNode node = new NonLeafNode();
        node.numberOfSon = this.documentObject.readByte();
        node.minKeyValue = DocumentObjectUtil.readValue(this.documentObject, this.keyDataType);
        node.maxKeyValue = DocumentObjectUtil.readValue(this.documentObject, this.keyDataType);
        node.offset = this.documentObject.readInt();
        return node;
    }

    private IndexKey readKeyObject() throws IOException {
        IndexKey keyObject = new IndexKey();
        int[] dimensionPos = null;
        if (this.currentVersion > 0) {
            dimensionPos = new int[this.documentObject.readInt()];
            int i = 0;
            while (i < dimensionPos.length) {
                dimensionPos[i] = this.documentObject.readInt();
                ++i;
            }
            keyObject.setDimensionPos(dimensionPos);
        } else {
            dimensionPos = new int[]{this.documentObject.readInt()};
            keyObject.setDimensionPos(dimensionPos);
        }
        keyObject.setKey(DocumentObjectUtil.readValue(this.documentObject, this.keyDataType));
        int[] offset = null;
        if (this.currentVersion > 0) {
            offset = new int[this.documentObject.readInt()];
            int i = 0;
            while (i < offset.length) {
                offset[i] = this.documentObject.readInt();
                ++i;
            }
            keyObject.setOffset(offset);
        } else {
            offset = new int[]{this.documentObject.readInt()};
            keyObject.setOffset(offset);
        }
        return keyObject;
    }

    private void createDocumentObject() throws IOException, DataException {
        this.documentObject = this.documentManager.createDocumentObject(this.name);
        this.offsetDocumentObject = this.documentManager.createDocumentObject(DiskIndex.getOffsetDocName(this.name));
    }

    private IDiskArray sortKeys(IDiskArray keyList) throws IOException {
        DiskSortedStack sortStack = new DiskSortedStack(Math.min(keyList.size(), Constants.MAX_LIST_BUFFER_SIZE), false, IndexKey.getKeyComparator(), IndexKey.getCreator());
        int i = 0;
        while (i < keyList.size()) {
            sortStack.push((IComparableStructure)keyList.get(i));
            ++i;
        }
        BufferedStructureArray reList = new BufferedStructureArray(IndexKey.getCreator(), Math.min(keyList.size(), Constants.MAX_LIST_BUFFER_SIZE));
        IndexKey curIndexKey = null;
        ArrayList<Integer> dimPos = new ArrayList<Integer>();
        ArrayList<Integer> dimOffset = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < keyList.size()) {
            IndexKey indexKey = (IndexKey)sortStack.pop();
            if (curIndexKey == null) {
                curIndexKey = indexKey;
                dimPos.add(new Integer(curIndexKey.getDimensionPos()[0]));
                dimOffset.add(new Integer(curIndexKey.getOffset()[0]));
            } else if (indexKey.compareTo(curIndexKey) == 0) {
                dimPos.add(new Integer(indexKey.getDimensionPos()[0]));
                dimOffset.add(indexKey.getOffset()[0]);
            } else {
                this.addIndex(reList, curIndexKey, dimPos, dimOffset);
                curIndexKey = indexKey;
                dimPos.clear();
                dimPos.add(curIndexKey.getDimensionPos()[0]);
                dimOffset.clear();
                dimOffset.add(curIndexKey.getOffset()[0]);
            }
            ++i2;
        }
        this.addIndex(reList, curIndexKey, dimPos, dimOffset);
        return reList;
    }

    private void addIndex(BufferedStructureArray reList, IndexKey curIndexKey, List<Integer> dimPos, List<Integer> dimOffset) throws IOException {
        int[] iDimPos = new int[dimPos.size()];
        int j = 0;
        while (j < iDimPos.length) {
            iDimPos[j] = dimPos.get(j);
            ++j;
        }
        int[] iDimOffset = new int[dimOffset.size()];
        int j2 = 0;
        while (j2 < iDimOffset.length) {
            iDimOffset[j2] = dimOffset.get(j2);
            ++j2;
        }
        curIndexKey.setDimensionPos(iDimPos);
        curIndexKey.setOffset(iDimOffset);
        reList.add(curIndexKey);
    }

    public IDiskArray find(Object[] value) throws IOException, DataException {
        ISelection[] selections = new ISelection[]{new OneKeySelection(value)};
        return this.find(selections);
    }

    public IndexKey findFirst(Object[] key) throws IOException, DataException {
        this.documentObject.seek(this.rootNodeOffset);
        NonLeafNode currentNode = this.readNonLeafNode();
        NonLeafNode tempNode = null;
        if (!this.checkValid(currentNode)) {
            throw new DataException("data.olap.OlapFileDataError", this.name);
        }
        if (!this.isBetween(currentNode, key)) {
            return null;
        }
        int i = 0;
        while (i < this.numberOfLevel - 1) {
            boolean find = false;
            this.documentObject.seek(currentNode.offset);
            int j = 0;
            while (j < currentNode.numberOfSon) {
                tempNode = this.readNonLeafNode();
                if (this.isBetween(tempNode, key)) {
                    find = true;
                    break;
                }
                ++j;
            }
            if (!find) {
                return null;
            }
            currentNode = tempNode;
            ++i;
        }
        this.documentObject.seek(currentNode.offset);
        i = 0;
        while (i < currentNode.numberOfSon) {
            IndexKey indexKey = this.readKeyObject();
            if (CompareUtil.compare(indexKey.getKey(), key) == 0) {
                return indexKey;
            }
            ++i;
        }
        return null;
    }

    private boolean isBetween(NonLeafNode node, Object[] key) {
        return CompareUtil.compare(node.minKeyValue, key) <= 0 && CompareUtil.compare(node.maxKeyValue, key) >= 0;
    }

    public IDiskArray findAll() throws IOException, DataException {
        return this.topN(this.keyCount);
    }

    public IDiskArray find(ISelection[] selections) throws IOException, DataException {
        this.documentObject.seek(this.rootNodeOffset);
        NonLeafNode currentNode = this.readNonLeafNode();
        if (!this.checkValid(currentNode)) {
            throw new DataException("data.olap.OlapFileDataError", this.name);
        }
        boolean find = false;
        NodeSelection nodeSelection = new NodeSelection(currentNode, selections.length);
        int i = 0;
        while (i < selections.length) {
            if (this.match(currentNode, selections[i])) {
                nodeSelection.addSelection(i);
                find = true;
            }
            ++i;
        }
        if (!find) {
            return null;
        }
        BufferedStructureArray validNodeList = new BufferedStructureArray(NodeSelection.getCreator(), Math.min(this.keyCount, Constants.MAX_LIST_BUFFER_SIZE));
        validNodeList.add(nodeSelection);
        BufferedStructureArray validSonNode = new BufferedStructureArray(NodeSelection.getCreator(), Math.min(this.keyCount, Constants.MAX_LIST_BUFFER_SIZE));
        int i2 = 0;
        while (i2 < this.numberOfLevel - 1) {
            int j = 0;
            while (j < validNodeList.size()) {
                this.processNonLeafNode((NodeSelection)validNodeList.get(j), selections, validSonNode);
                ++j;
            }
            if (validSonNode.size() <= 0) {
                return null;
            }
            BufferedStructureArray tempList = validNodeList;
            validNodeList = validSonNode;
            validSonNode = tempList;
            validSonNode.clear();
            ++i2;
        }
        BufferedStructureArray resultList = new BufferedStructureArray(IndexKey.getCreator(), Math.min(this.keyCount, Constants.MAX_LIST_BUFFER_SIZE));
        int i3 = 0;
        while (i3 < validNodeList.size()) {
            currentNode = ((NodeSelection)validNodeList.get((int)i3)).node;
            boolean[] selectionMark = ((NodeSelection)validNodeList.get((int)i3)).selectionMark;
            this.documentObject.seek(currentNode.offset);
            int j = 0;
            while (j < currentNode.numberOfSon) {
                IndexKey indexKey = this.readKeyObject();
                int k = 0;
                while (k < selectionMark.length) {
                    if (selectionMark[k] && selections[k].isSelected(indexKey.getKey())) {
                        resultList.add(indexKey);
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        return resultList;
    }

    public IDiskArray topN(int n) throws IOException {
        BufferedStructureArray resultList = new BufferedStructureArray(IndexKey.getCreator(), Math.min(n, Constants.MAX_LIST_BUFFER_SIZE));
        this.offsetDocumentObject.seek((this.keyCount - n) * 4);
        this.documentObject.seek(this.offsetDocumentObject.readInt());
        int i = 0;
        while (i < n) {
            resultList.add(this.readKeyObject());
            ++i;
        }
        return resultList;
    }

    public IDiskArray topPercent(double percent) throws IOException {
        return this.topN((int)((double)this.keyCount * percent));
    }

    public IDiskArray bottomN(int n) throws IOException {
        BufferedStructureArray resultList = new BufferedStructureArray(IndexKey.getCreator(), Math.min(n, Constants.MAX_LIST_BUFFER_SIZE));
        this.offsetDocumentObject.seek(0L);
        this.documentObject.seek(this.offsetDocumentObject.readInt());
        int i = 0;
        while (i < n) {
            resultList.add(this.readKeyObject());
            ++i;
        }
        return resultList;
    }

    public IDiskArray bottomPercent(double percent) throws IOException {
        return this.bottomN((int)((double)this.keyCount * percent));
    }

    private boolean checkValid(NonLeafNode node) {
        if (node.maxKeyValue == null || node.minKeyValue == null || CompareUtil.compare(node.maxKeyValue, node.minKeyValue) < 0) {
            return false;
        }
        if (node.numberOfSon > this.degree || node.numberOfSon <= 0) {
            return false;
        }
        return node.offset >= 0;
    }

    private void processNonLeafNode(NodeSelection nodeSelection, ISelection[] selections, IDiskArray resultList) throws IOException {
        NonLeafNode tempNode = null;
        NodeSelection tempNodeSelection = null;
        boolean find = false;
        this.documentObject.seek(nodeSelection.node.offset);
        int i = 0;
        while (i < nodeSelection.node.numberOfSon) {
            tempNode = this.readNonLeafNode();
            tempNodeSelection = new NodeSelection(tempNode, selections.length);
            find = false;
            int j = 0;
            while (j < nodeSelection.selectionMark.length) {
                if (nodeSelection.selectionMark[j] && this.match(tempNode, selections[j])) {
                    tempNodeSelection.addSelection(j);
                    find = true;
                }
                ++j;
            }
            if (find) {
                resultList.add(tempNodeSelection);
            }
            ++i;
        }
    }

    private boolean match(NonLeafNode node, ISelection selection) {
        if (selection.getMin() != null && CompareUtil.compare(node.maxKeyValue, selection.getMin()) < 0) {
            return false;
        }
        return selection.getMax() == null || CompareUtil.compare(node.minKeyValue, selection.getMax()) <= 0;
    }

    public void close() throws IOException {
        if (this.documentObject != null) {
            this.documentObject.close();
            this.documentObject = null;
        }
        if (this.offsetDocumentObject != null) {
            this.offsetDocumentObject.close();
            this.offsetDocumentObject = null;
        }
    }
}

