/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class EngineLogger {
    private static final String BIRT_NAME_SPACE = "org.eclipse.birt";
    private static final Logger ROOT_LOGGER = Logger.getLogger("org.eclipse.birt");
    private static String logFileName;
    private static int logRollingSize;
    private static int logMaxBackupIndex;
    private static AdapterHandler adapterHandler;

    public static void startEngineLogging(Logger logger, String directoryName, String fileName, Level logLevel, int rollingSize, int maxBackupIndex) {
        if (logger != null) {
            if (!EngineLogger.isValidLogger(logger)) {
                logger.log(Level.WARNING, "the logger can't be the child of org.eclipse.birt");
            } else {
                AdapterHandler adapter = EngineLogger.getAdapterHandler();
                adapter.setUserLogger(logger);
            }
        }
        if (directoryName != null || fileName != null) {
            FileHandler fileHandler;
            logFileName = EngineLogger.generateUniqueLogFileName(directoryName, fileName);
            logRollingSize = rollingSize;
            logMaxBackupIndex = maxBackupIndex;
            if (logLevel != Level.OFF && (fileHandler = EngineLogger.createFileLogger(logFileName, logRollingSize, logMaxBackupIndex, logLevel)) != null) {
                AdapterHandler adapter = EngineLogger.getAdapterHandler();
                adapter.setFileHandler(fileHandler);
            }
        }
        ROOT_LOGGER.setLevel(logLevel);
    }

    public static void setLogger(Logger logger) {
        if (logger != null && !EngineLogger.isValidLogger(logger)) {
            logger.log(Level.WARNING, "the logger can't be the child of org.eclipse.birt");
        }
        AdapterHandler adapter = EngineLogger.getAdapterHandler();
        adapter.setUserLogger(logger);
    }

    public static boolean isValidLogger(Logger logger) {
        while (logger != null) {
            if (logger == ROOT_LOGGER) {
                return false;
            }
            logger = logger.getParent();
        }
        return true;
    }

    public static void stopEngineLogging() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                EngineLogger.doStopEngineLogging();
                return null;
            }
        });
    }

    private static void doStopEngineLogging() {
        if (adapterHandler != null) {
            ROOT_LOGGER.setUseParentHandlers(true);
            ROOT_LOGGER.removeHandler(adapterHandler);
            adapterHandler.close();
            adapterHandler = null;
        }
        logFileName = null;
        logRollingSize = 0;
        logMaxBackupIndex = 0;
    }

    public static void changeLogLevel(Level newLevel) {
        FileHandler fileHandler;
        AdapterHandler adapter;
        if (logFileName != null && newLevel != Level.OFF && (adapter = EngineLogger.getAdapterHandler()).fileHandler == null && (fileHandler = EngineLogger.createFileLogger(logFileName, logRollingSize, logMaxBackupIndex, newLevel)) != null) {
            adapter.setFileHandler(fileHandler);
        }
        ROOT_LOGGER.setLevel(newLevel);
    }

    private static String generateUniqueLogFileName(String directoryName, String fileName) {
        if (fileName == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            String dateTimeString = df.format(new Date());
            fileName = "ReportEngine_" + dateTimeString + ".log";
        }
        if (directoryName == null || directoryName.length() == 0) {
            return fileName;
        }
        File folder = new File(directoryName);
        File file = new File(folder, fileName);
        return file.getPath();
    }

    private static FileHandler createFileLogger(String fileName, int rollingSize, int logMaxBackupIndex, Level level) {
        try {
            File path = new File(fileName).getParentFile();
            if (path != null) {
                path.mkdirs();
            }
            if (logMaxBackupIndex <= 0) {
                logMaxBackupIndex = 1;
            }
            if (rollingSize < 0) {
                rollingSize = 0;
            }
            FileHandler logFileHandler = new FileHandler(fileName, rollingSize, logMaxBackupIndex, true);
            logFileHandler.setFormatter(new SimpleFormatter());
            if (level == null) {
                logFileHandler.setLevel(Level.WARNING);
            } else {
                logFileHandler.setLevel(level);
            }
            logFileHandler.setEncoding("utf-8");
            return logFileHandler;
        }
        catch (SecurityException e) {
            ROOT_LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            ROOT_LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static AdapterHandler getAdapterHandler() {
        if (adapterHandler != null) return adapterHandler;
        Class<EngineLogger> clazz = EngineLogger.class;
        synchronized (EngineLogger.class) {
            if (adapterHandler != null) return adapterHandler;
            adapterHandler = new AdapterHandler(ROOT_LOGGER.getParent());
            ROOT_LOGGER.addHandler(adapterHandler);
            ROOT_LOGGER.setUseParentHandlers(false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return adapterHandler;
        }
    }

    public static void setThreadLogger(Logger logger) {
        if (logger == null && adapterHandler == null) {
            return;
        }
        AdapterHandler adapter = EngineLogger.getAdapterHandler();
        adapter.setThreadLogger(logger);
    }

    static class AdapterHandler
    extends Handler {
        private Logger parent;
        private Logger userLogger;
        private Handler fileHandler;
        private ThreadLocal<Logger> threadLoggers;

        public AdapterHandler(Logger logger) {
            this.parent = logger;
        }

        public void setUserLogger(Logger logger) {
            this.userLogger = logger;
        }

        public void setFileHandler(FileHandler fileHandler) {
            this.fileHandler = fileHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setThreadLogger(Logger logger) {
            if (logger != null) {
                if (this.threadLoggers == null) {
                    AdapterHandler adapterHandler = this;
                    synchronized (adapterHandler) {
                        if (this.threadLoggers == null) {
                            this.threadLoggers = new ThreadLocal();
                        }
                    }
                }
                this.threadLoggers.set(logger);
            } else if (this.threadLoggers != null) {
                this.threadLoggers.set(null);
            }
        }

        public void publish(LogRecord record) {
            Logger logger;
            if (this.threadLoggers != null && (logger = this.threadLoggers.get()) != null) {
                this.publishToLogger(logger, record);
                return;
            }
            if (this.userLogger != null || this.fileHandler != null) {
                if (this.userLogger != null) {
                    this.publishToLogger(this.userLogger, record);
                }
                if (this.fileHandler != null) {
                    this.fileHandler.publish(record);
                }
                return;
            }
            this.publishToLogger(this.parent, record);
        }

        public void close() throws SecurityException {
            if (this.fileHandler != null) {
                this.fileHandler.close();
                this.fileHandler = null;
            }
        }

        public void flush() {
            if (this.fileHandler != null) {
                this.fileHandler.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void publishToLogger(Logger logger, LogRecord record) {
            if (!logger.isLoggable(record.getLevel())) {
                return;
            }
            var3_3 = logger;
            synchronized (var3_3) {
                filter = logger.getFilter();
                if (filter != null && !filter.isLoggable(record)) {
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                if (true) ** GOTO lbl22
            }
            do {
                if ((targets = logger.getHandlers()) != null) {
                    i = 0;
                    while (i < targets.length) {
                        targets[i].publish(record);
                        ++i;
                    }
                }
                if (!logger.getUseParentHandlers()) break;
                logger = logger.getParent();
lbl22:
                // 2 sources

            } while (logger != null);
        }
    }
}

