/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedObjectManager<T>
implements Iterable<T> {
    private LinkedEntry<T> first;
    private LinkedEntry<T> last;
    private int modCount = 0;

    @Override
    public Iterator<T> iterator() {
        return new InternalIterator();
    }

    public LinkedEntry<T> add(T object) {
        LinkedEntry entry = new LinkedEntry(this, object);
        this.add(entry);
        return entry;
    }

    public void add(LinkedEntry<T> entry) {
        if (entry == null) {
            return;
        }
        entry.setNext(null);
        entry.setPrevious(this.last);
        if (this.first == null) {
            this.first = entry;
        }
        if (this.last != null) {
            this.last.setNext(entry);
        }
        this.last = entry;
        ++this.modCount;
    }

    public void remove(LinkedEntry<T> entry) {
        if (entry.getManager() != this) {
            return;
        }
        LinkedEntry<T> previous = entry.getPrevious();
        LinkedEntry<T> next = entry.getNext();
        if (previous != null) {
            previous.setNext(next);
        }
        if (next != null) {
            next.setPrevious(previous);
        }
        if (this.first == entry) {
            this.first = next;
        }
        if (this.last == entry) {
            this.last = previous;
        }
        entry.setNext(null);
        entry.setPrevious(null);
        --this.modCount;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.modCount = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalIterator
    implements Iterator<T> {
        private LinkedEntry<T> next;
        private LinkedEntry<T> current;
        private int expectedModCount = 0;

        public InternalIterator() {
            this.next = LinkedObjectManager.this.first;
            this.expectedModCount = LinkedObjectManager.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (LinkedObjectManager.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedEntry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Object value = entry.getValue();
            this.current = entry;
            this.next = entry.getNext();
            return value;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (LinkedObjectManager.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedObjectManager.this.remove(this.current);
            this.current = null;
            this.expectedModCount = LinkedObjectManager.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedEntry<T> {
        private LinkedEntry<T> previous;
        private LinkedEntry<T> next;
        private LinkedObjectManager<T> manager;
        private T value;

        private LinkedEntry(LinkedObjectManager<T> manager, T value) {
            this.manager = manager;
            this.value = value;
        }

        public LinkedEntry<T> getPrevious() {
            return this.previous;
        }

        public void setPrevious(LinkedEntry<T> previousEntry) {
            this.previous = previousEntry;
        }

        public LinkedEntry<T> getNext() {
            return this.next;
        }

        public void setNext(LinkedEntry<T> nextEntry) {
            this.next = nextEntry;
        }

        public T getValue() {
            return this.value;
        }

        public LinkedObjectManager<T> getManager() {
            return this.manager;
        }
    }
}

