/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.TaskOption;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.CompositeContentEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ContextPageBreakHandler;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.layout.CompositeLayoutPageHandler;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.nLayout.LayoutEngine;

public class RunAndRenderTask
extends EngineTask
implements IRunAndRenderTask {
    protected IReportLayoutEngine layoutEngine;

    public RunAndRenderTask(ReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable, 3);
    }

    public void run() throws EngineException {
        if (this.progressMonitor != null) {
            this.progressMonitor.onProgress(1, 3);
        }
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
            if (this.progressMonitor != null) {
                this.progressMonitor.onProgress(2, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRun() throws EngineException {
        this.loadScripts();
        this.doValidateParameters();
        this.setupRenderOption();
        this.initReportVariable();
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        this.updateRtLFlag();
        this.startRender();
        try {
            Object taskOption;
            IContentEmitter emitter = this.createContentEmitter();
            IReportExecutor executor = new ReportExecutor(this.executionContext);
            executor = new SuppressDuplciateReportExecutor(executor);
            executor = new LocalizedReportExecutor(this.executionContext, executor);
            this.executionContext.setExecutor(executor);
            if ("paper-size-pagination".equals(this.pagination)) {
                LayoutEngine pdfLayoutEmitter = new LayoutEngine(executor, emitter, this.renderOptions, this.executionContext, 0L);
                emitter = pdfLayoutEmitter;
            }
            this.initializeContentEmitter(emitter);
            String format = this.executionContext.getOutputFormat();
            boolean paginate = true;
            if ("html".equalsIgnoreCase(format) || "xhtml".equalsIgnoreCase(format)) {
                HTMLRenderOption htmlOption = new HTMLRenderOption(this.executionContext.getRenderOption());
                paginate = htmlOption.getHtmlPagination();
            } else {
                taskOption = new RenderOption(this.executionContext.getRenderOption());
                paginate = ((TaskOption)taskOption).getBooleanOption("htmlPagination", true);
            }
            if ("no-pagination".equals(this.pagination)) {
                paginate = false;
            }
            taskOption = this;
            synchronized (taskOption) {
                if (!this.executionContext.isCanceled()) {
                    this.layoutEngine = this.createReportLayoutEngine(this.pagination, this.renderOptions);
                }
            }
            if (this.layoutEngine != null) {
                this.layoutEngine.setLocale(this.executionContext.getLocale());
                CompositeLayoutPageHandler layoutPageHandler = new CompositeLayoutPageHandler();
                OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(this.executionContext);
                layoutPageHandler.addPageHandler(handle);
                layoutPageHandler.addPageHandler(new ContextPageBreakHandler(this.executionContext));
                if (!"paper-size-pagination".equals(this.pagination)) {
                    layoutPageHandler.addPageHandler(new LayoutPageHandler());
                    this.layoutEngine.setPageHandler(layoutPageHandler);
                } else {
                    ((LayoutEngine)emitter).setPageHandler(layoutPageHandler);
                }
                CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                outputEmitters.addEmitter(emitter);
                outputEmitters.addEmitter(handle.getEmitter());
                IReportContent report = executor.execute();
                outputEmitters.start(report);
                this.layoutEngine.layout(executor, report, outputEmitters, paginate);
                this.layoutEngine.close();
                outputEmitters.end(report);
            }
            this.closeRender();
            this.executionContext.closeDataEngine();
            this.closeFactory();
        }
        catch (Throwable t) {
            this.handleFatalExceptions(t);
        }
    }

    public void cancel() {
        super.cancel();
        if (this.layoutEngine != null) {
            this.layoutEngine.cancel();
        }
    }

    public void setMaxRowsPerQuery(int maxRows) {
        this.executionContext.setMaxRowsPerQuery(maxRows);
    }

    private class LayoutPageHandler
    implements ILayoutPageHandler {
        private LayoutPageHandler() {
        }

        public void onPage(long pageNumber, Object context) {
            if (RunAndRenderTask.this.pageHandler != null) {
                RunAndRenderTask.this.pageHandler.onPage((int)pageNumber, false, null);
            }
            RunAndRenderTask.this.executionContext.getProgressMonitor().onProgress(4, (int)pageNumber);
        }
    }
}

