/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value;

import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.IdentifierManager;
import org.eclipse.birt.report.engine.css.engine.value.Messages;
import org.eclipse.birt.report.engine.css.engine.value.RGBColorValue;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public abstract class AbstractColorManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();
    protected static final StringMap computedValues;

    static {
        AbstractColorManager.addColorIndent(values);
        computedValues = new StringMap();
        computedValues.put("black", CSSValueConstants.BLACK_RGB_VALUE);
        computedValues.put("silver", CSSValueConstants.SILVER_RGB_VALUE);
        computedValues.put("gray", CSSValueConstants.GRAY_RGB_VALUE);
        computedValues.put("white", CSSValueConstants.WHITE_RGB_VALUE);
        computedValues.put("maroon", CSSValueConstants.MAROON_RGB_VALUE);
        computedValues.put("red", CSSValueConstants.RED_RGB_VALUE);
        computedValues.put("purple", CSSValueConstants.PURPLE_RGB_VALUE);
        computedValues.put("fuchsia", CSSValueConstants.FUCHSIA_RGB_VALUE);
        computedValues.put("green", CSSValueConstants.GREEN_RGB_VALUE);
        computedValues.put("lime", CSSValueConstants.LIME_RGB_VALUE);
        computedValues.put("olive", CSSValueConstants.OLIVE_RGB_VALUE);
        computedValues.put("orange", CSSValueConstants.ORANGE_RGB_VALUE);
        computedValues.put("yellow", CSSValueConstants.YELLOW_RGB_VALUE);
        computedValues.put("navy", CSSValueConstants.NAVY_RGB_VALUE);
        computedValues.put("blue", CSSValueConstants.BLUE_RGB_VALUE);
        computedValues.put("teal", CSSValueConstants.TEAL_RGB_VALUE);
        computedValues.put("aqua", CSSValueConstants.AQUA_RGB_VALUE);
        computedValues.put("transparent", CSSValueConstants.TRANSPARENT_VALUE);
    }

    public static void addColorIndent(StringMap values) {
        values.put("aqua", CSSValueConstants.AQUA_VALUE);
        values.put("black", CSSValueConstants.BLACK_VALUE);
        values.put("blue", CSSValueConstants.BLUE_VALUE);
        values.put("fuchsia", CSSValueConstants.FUCHSIA_VALUE);
        values.put("gray", CSSValueConstants.GRAY_VALUE);
        values.put("green", CSSValueConstants.GREEN_VALUE);
        values.put("lime", CSSValueConstants.LIME_VALUE);
        values.put("maroon", CSSValueConstants.MAROON_VALUE);
        values.put("navy", CSSValueConstants.NAVY_VALUE);
        values.put("olive", CSSValueConstants.OLIVE_VALUE);
        values.put("orange", CSSValueConstants.ORANGE_VALUE);
        values.put("purple", CSSValueConstants.PURPLE_VALUE);
        values.put("red", CSSValueConstants.RED_VALUE);
        values.put("silver", CSSValueConstants.SILVER_VALUE);
        values.put("teal", CSSValueConstants.TEAL_VALUE);
        values.put("white", CSSValueConstants.WHITE_VALUE);
        values.put("yellow", CSSValueConstants.YELLOW_VALUE);
        values.put("ActiveBorder", CSSValueConstants.ACTIVEBORDER_VALUE);
        values.put("ActiveCaption", CSSValueConstants.ACTIVECAPTION_VALUE);
        values.put("AppWorkspace", CSSValueConstants.APPWORKSPACE_VALUE);
        values.put("Background", CSSValueConstants.BACKGROUND_VALUE);
        values.put("ButtonFace", CSSValueConstants.BUTTONFACE_VALUE);
        values.put("ButtonHighlight", CSSValueConstants.BUTTONHIGHLIGHT_VALUE);
        values.put("ButtonShadow", CSSValueConstants.BUTTONSHADOW_VALUE);
        values.put("ButtonText", CSSValueConstants.BUTTONTEXT_VALUE);
        values.put("CaptionText", CSSValueConstants.CAPTIONTEXT_VALUE);
        values.put("GrayText", CSSValueConstants.GRAYTEXT_VALUE);
        values.put("Highlight", CSSValueConstants.HIGHLIGHT_VALUE);
        values.put("HighlightText", CSSValueConstants.HIGHLIGHTTEXT_VALUE);
        values.put("InactiveBorder", CSSValueConstants.INACTIVEBORDER_VALUE);
        values.put("InactiveCaption", CSSValueConstants.INACTIVECAPTION_VALUE);
        values.put("InactiveCaptionText", CSSValueConstants.INACTIVECAPTIONTEXT_VALUE);
        values.put("InfoBackground", CSSValueConstants.INFOBACKGROUND_VALUE);
        values.put("InfoText", CSSValueConstants.INFOTEXT_VALUE);
        values.put("menu", CSSValueConstants.MENU_VALUE);
        values.put("MenuText", CSSValueConstants.MENUTEXT_VALUE);
        values.put("Scrollbar", CSSValueConstants.SCROLLBAR_VALUE);
        values.put("ThreeDDarkShadow", CSSValueConstants.THREEDDARKSHADOW_VALUE);
        values.put("ThreeDFace", CSSValueConstants.THREEDFACE_VALUE);
        values.put("ThreeDHighlight", CSSValueConstants.THREEDHIGHLIGHT_VALUE);
        values.put("ThreeDLightShadow", CSSValueConstants.THREEDLIGHTSHADOW_VALUE);
        values.put("ThreeDShadow", CSSValueConstants.THREEDSHADOW_VALUE);
        values.put("Window", CSSValueConstants.WINDOW_VALUE);
        values.put("WindowFrame", CSSValueConstants.WINDOWFRAME_VALUE);
        values.put("WindowText", CSSValueConstants.WINDOWTEXT_VALUE);
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == 27) {
            lu = lu.getParameters();
            Value red = this.createColorComponent(lu);
            lu = lu.getNextLexicalUnit().getNextLexicalUnit();
            Value green = this.createColorComponent(lu);
            lu = lu.getNextLexicalUnit().getNextLexicalUnit();
            Value blue = this.createColorComponent(lu);
            return this.createRGBColor(red, green, blue);
        }
        return super.createValue(lu, engine);
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        if (value.getCssValueType() == 1) {
            Value pvalue = value;
            short primitiveType = pvalue.getPrimitiveType();
            if (primitiveType == 21) {
                String ident = pvalue.getStringValue();
                Value v = (Value)computedValues.get(ident);
                if (v != null) {
                    return v;
                }
                if (values.get(ident) == null) {
                    throw new InternalError();
                }
                return (Value)engine.getCSSContext().getSystemColor(ident);
            }
            if (primitiveType == 25) {
                RGBColor color = value.getRGBColorValue();
                CSSPrimitiveValue red = color.getRed();
                CSSPrimitiveValue green = color.getGreen();
                CSSPrimitiveValue blue = color.getBlue();
                return this.createRGBColor(this.createColorComponent(red), this.createColorComponent(green), this.createColorComponent(blue));
            }
        }
        return super.computeValue(elt, engine, idx, value);
    }

    protected CSSPrimitiveValue createColorComponent(CSSPrimitiveValue value) throws DOMException {
        if (value.getPrimitiveType() == 2) {
            float v = value.getFloatValue((short)2);
            v = v < 0.0f ? 0.0f : (v > 100.0f ? 1.0f : 255.0f * v / 100.0f);
            return new FloatValue(1, v);
        }
        if (value.getPrimitiveType() == 1) {
            float v = value.getFloatValue((short)1);
            if (v <= 0.0f) {
                v = 0.0f;
            } else if (v >= 255.0f) {
                v = 255.0f;
            }
            return new FloatValue(1, v);
        }
        return value;
    }

    protected Value createRGBColor(CSSPrimitiveValue r, CSSPrimitiveValue g, CSSPrimitiveValue b) {
        return new RGBColorValue(r, g, b);
    }

    protected Value createColorComponent(LexicalUnit lu) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 13: {
                return new FloatValue(1, lu.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lu.getFloatValue());
            }
            case 23: {
                return new FloatValue(2, lu.getFloatValue());
            }
        }
        throw this.createInvalidRGBComponentUnitDOMException(lu.getLexicalUnitType());
    }

    public StringMap getIdentifiers() {
        return values;
    }

    private DOMException createInvalidRGBComponentUnitDOMException(short type) {
        Object[] p = new Object[]{this.getPropertyName(), (int)type};
        String s = Messages.formatMessage("invalid.rgb.component.unit", p);
        return new DOMException(9, s);
    }
}

