/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmitterContext {
    private LinkedList<TableInfo> tables = new LinkedList();
    private LinkedList<Integer> widthList = new LinkedList();
    private Stack<Boolean> cellind = new Stack();
    private boolean isFirst = true;
    private boolean isAfterTable = false;

    public void setIsAfterTable(boolean isTable) {
        this.isAfterTable = isTable;
    }

    public boolean isAfterTable() {
        return this.isAfterTable;
    }

    public void startInline() {
        this.isFirst = false;
    }

    public boolean isFirstInline() {
        return this.isFirst;
    }

    public void endInline() {
        this.isFirst = true;
    }

    public void startCell() {
        this.cellind.push(true);
    }

    public void endCell() {
        this.cellind.pop();
    }

    public boolean needEmptyP() {
        return this.cellind.peek();
    }

    public void addContainer(boolean isContainer) {
        if (!this.cellind.isEmpty()) {
            this.cellind.pop();
            this.cellind.push(isContainer);
        }
    }

    public void addWidth(int witdh) {
        this.widthList.addLast(witdh);
    }

    public void resetWidth() {
        this.widthList.clear();
    }

    public int getCurrentWidth() {
        return this.widthList.getLast();
    }

    public void removeWidth() {
        this.widthList.removeLast();
    }

    public int[] getCurrentTableColmns() {
        return this.tables.getLast().getColumnWidths();
    }

    public void addTable(int[] cols, IStyle style) {
        this.tables.addLast(new TableInfo(cols, style));
    }

    public IStyle getTableStyle() {
        return this.tables.getLast().getTableStyle();
    }

    public void newRow() {
        this.tables.getLast().newRow();
    }

    public void addSpan(int colmunId, int columnSpan, int cellWidth, int rowSpan, IStyle style) {
        this.tables.getLast().addSpan(colmunId, columnSpan, cellWidth, rowSpan, style);
    }

    public void removeTable() {
        this.tables.removeLast();
    }

    public List<SpanInfo> getSpans(int col) {
        return this.tables.getLast().getSpans(col);
    }

    public int getCellWidth(int columnId, int columnSpan) {
        int[] cols = this.getCurrentTableColmns();
        int width = 0;
        int colNum = Math.min(columnId + columnSpan, 63);
        int i = columnId;
        while (i < colNum) {
            width += cols[i];
            ++i;
        }
        return width;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TableInfo {
        private Hashtable<Integer, List<SpanInfo>> spans = new Hashtable();
        private int[] cols;
        private int crow = 0;
        IStyle style = null;

        TableInfo(int[] cols, IStyle style) {
            this.cols = cols;
            this.style = style;
        }

        void newRow() {
            ++this.crow;
        }

        void addSpan(int columnId, int columnSpan, int cellWidth, int rowSpan, IStyle style) {
            int i = 1;
            while (i < rowSpan) {
                List<Object> rSpan;
                Integer key = this.crow + i;
                if (this.spans.containsKey(key)) {
                    rSpan = this.spans.get(key);
                    rSpan.add(new SpanInfo(columnId, columnSpan, cellWidth, false, style));
                    Collections.sort(rSpan, new Comparator<SpanInfo>(){

                        @Override
                        public int compare(SpanInfo o1, SpanInfo o2) {
                            SpanInfo r1 = o1;
                            SpanInfo r2 = o2;
                            return r1.getColumnId() - r2.getColumnId();
                        }
                    });
                } else {
                    rSpan = new Vector<SpanInfo>();
                    ((Vector)rSpan).add(new SpanInfo(columnId, columnSpan, cellWidth, false, style));
                    this.spans.put(key, rSpan);
                }
                ++i;
            }
        }

        List<SpanInfo> getSpans(int end) {
            List<SpanInfo> cSpans = this.spans.get(this.crow);
            if (cSpans == null) {
                return null;
            }
            Vector<SpanInfo> cList = new Vector<SpanInfo>();
            int pos = -1;
            int i = 0;
            while (i < cSpans.size()) {
                SpanInfo r = cSpans.get(i);
                if (r.getColumnId() + r.getColumnSpan() - 1 > end) break;
                cList.add(r);
                pos = i++;
            }
            i = 0;
            while (i <= pos) {
                cSpans.remove(0);
                ++i;
            }
            if (cSpans.size() == 0) {
                this.removeSpan();
            }
            return cList.size() == 0 ? null : cList;
        }

        public void removeSpan() {
            this.spans.remove(this.crow);
        }

        int[] getColumnWidths() {
            return this.cols;
        }

        int getRow() {
            return this.crow;
        }

        IStyle getTableStyle() {
            return this.style;
        }
    }
}

