/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.SingleCubeResultSet;
import org.eclipse.birt.report.engine.data.dte.SingleQueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemGeneration;
import org.eclipse.birt.report.engine.extension.internal.ReportItemGenerationInfo;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ExtendedGenerateExecutor
extends QueryItemExecutor {
    IReportItemGeneration itemGeneration;
    IBaseResultSet[] rsets;

    public ExtendedGenerateExecutor(ExecutorManager manager, IReportItemGeneration itemGeneration) {
        super(manager, -1);
        this.itemGeneration = itemGeneration;
    }

    public void close() throws BirtException {
        this.closeQueries();
        super.close();
    }

    public IContent execute() {
        ExtendedItemDesign extDesign = (ExtendedItemDesign)this.design;
        IForeignContent extContent = this.report.createForeignContent();
        this.setContent(extContent);
        try {
            this.executeQueries();
        }
        catch (BirtException ex) {
            this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            this.context.addException(this.design.getHandle(), (BirtException)new EngineException(ex));
            return null;
        }
        this.initializeContent(extDesign, extContent);
        this.processAction(extDesign, extContent);
        this.processBookmark(extDesign, extContent);
        this.processStyle(extDesign, extContent);
        this.processVisibility(extDesign, extContent);
        this.processUserProperties(extDesign, extContent);
        this.generateContent(extDesign, extContent);
        return extContent;
    }

    protected void generateContent(ExtendedItemDesign item, IForeignContent content) {
        ExtendedItemHandle handle = (ExtendedItemHandle)item.getHandle();
        String name = item.getName();
        byte[] generationStatus = null;
        if (this.itemGeneration != null) {
            IDataQueryDefinition[] queries = item.getQueries();
            ReportItemGenerationInfo info = new ReportItemGenerationInfo();
            info.setModelObject(handle);
            info.setApplicationClassLoader(this.context.getApplicationClassLoader());
            info.setReportContext(this.context.getReportContext());
            info.setReportQueries(queries);
            info.setExtendedItemContent(content);
            this.itemGeneration.init(info);
            try {
                IBaseResultSet prset;
                IBaseResultSet[] resultSets = this.rsets;
                if (resultSets == null && (prset = this.getParentResultSet()) != null) {
                    int rsetType = prset.getType();
                    if (rsetType == 0) {
                        resultSets = new IBaseResultSet[]{new SingleQueryResultSet((IQueryResultSet)prset)};
                    } else if (rsetType == 1) {
                        resultSets = new IBaseResultSet[]{new SingleCubeResultSet((ICubeResultSet)prset)};
                    }
                }
                this.itemGeneration.onRowSets(resultSets);
                if (this.itemGeneration.needSerialization()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    this.itemGeneration.serialize(out);
                    generationStatus = out.toByteArray();
                }
                this.itemGeneration.finish();
            }
            catch (BirtException ex) {
                this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                this.context.addException(handle, (BirtException)new EngineException("Error.ExtendedItemGenerationError", (Object)(String.valueOf(handle.getExtensionName()) + (name != null ? " " + name : "")), (Throwable)ex));
            }
        }
        content.setRawType("object/external");
        content.setRawValue(generationStatus);
    }

    protected static byte[] readContent(InputStream in) throws IOException {
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int readSize = 0;
        readSize = bin.read(buffer);
        while (readSize != -1) {
            out.write(buffer, 0, readSize);
            readSize = bin.read(buffer);
        }
        return out.toByteArray();
    }

    protected void executeQueries() throws BirtException {
        ExtendedItemDesign extItem = (ExtendedItemDesign)this.design;
        IDataEngine dataEngine = this.context.getDataEngine();
        boolean useCache = extItem.useCachedResult();
        IDataQueryDefinition[] queries = extItem.getQueries();
        if (queries != null) {
            IBaseResultSet parent = this.getParentResultSet();
            this.rsets = new IBaseResultSet[queries.length];
            int i = 0;
            while (i < this.rsets.length) {
                this.rsets[i] = queries[i] == null ? null : dataEngine.execute(parent, queries[i], extItem.getHandle(), useCache);
                ++i;
            }
            if (this.rsets[0] instanceof IQueryResultSet) {
                this.rset = (IQueryResultSet)this.rsets[0];
            }
            this.context.setResultSets(this.rsets);
        }
    }

    protected void closeQueries() {
        if (this.rsets != null) {
            int i = 0;
            while (i < this.rsets.length) {
                if (this.rsets[i] != null) {
                    this.rsets[i].close();
                }
                ++i;
            }
        }
        this.rsets = null;
        this.rset = null;
    }
}

