/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.io.IOException;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.RenderTask;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.emitter.ContentDOMVisitor;
import org.eclipse.birt.report.engine.emitter.DOMBuilderEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IReportContentLoader;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintReaderV2;
import org.eclipse.birt.report.engine.internal.document.v2.ReportContentReaderV2;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.toc.ITreeNode;

public class ReportContentLoaderV2
implements IReportContentLoader {
    protected static Logger logger = Logger.getLogger(IReportContentLoader.class.getName());
    protected ExecutionContext context;
    protected IDataEngine dataEngine;
    protected IContentEmitter emitter;
    protected ReportContentReaderV2 reader;
    protected ReportContentReaderV2 pageReader;
    protected PageHintReaderV2 hintReader;
    protected Report report;
    protected IReportDocument reportDoc;
    protected ReportContent reportContent;
    protected IContent dummyReportContent;
    protected long currentOffset;
    protected Stack resultSets = new Stack();
    protected Stack contents = new Stack();
    protected IContentVisitor outputStartVisitor = new IContentVisitor(){

        public Object visit(IContent content, Object value) throws BirtException {
            return content.accept(this, value);
        }

        public Object visitContent(IContent content, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startContent(content);
            return value;
        }

        public Object visitPage(IPageContent page, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startPage(page);
            return value;
        }

        public Object visitContainer(IContainerContent container, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startContainer(container);
            return value;
        }

        public Object visitTable(ITableContent table, Object value) throws BirtException {
            int colCount = table.getColumnCount();
            int i = 0;
            while (i < colCount) {
                IColumn col = table.getColumn(i);
                InstanceID id = col.getInstanceID();
                if (id != null) {
                    long cid = id.getComponentID();
                    ColumnDesign colDesign = (ColumnDesign)ReportContentLoaderV2.this.report.getReportItemByID(cid);
                    col.setGenerateBy(colDesign);
                }
                ++i;
            }
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTable(table);
            return value;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) throws BirtException {
            this.setupGroupBand(tableBand);
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTableBand(tableBand);
            return value;
        }

        public Object visitRow(IRowContent row, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startRow(row);
            return value;
        }

        public Object visitCell(ICellContent cell, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startCell(cell);
            return value;
        }

        public Object visitText(ITextContent text, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startText(text);
            return value;
        }

        public Object visitLabel(ILabelContent label, Object value) throws BirtException {
            if (label.getGenerateBy() instanceof TemplateDesign) {
                TemplateDesign design = (TemplateDesign)label.getGenerateBy();
                String promptKey = design.getPromptTextKey();
                String promptText = design.getPromptText();
                label.setLabelKey(promptKey);
                label.setLabelText(promptText);
            }
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startLabel(label);
            return value;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            if (autoText.getType() == 0) {
                autoText.setText(String.valueOf(ReportContentLoaderV2.this.reportDoc.getPageCount()));
            }
            emitter.startAutoText(autoText);
            return value;
        }

        public Object visitData(IDataContent data, Object value) throws BirtException {
            String column;
            String valueExpr;
            DataItemDesign design;
            IContentEmitter emitter = (IContentEmitter)value;
            if (data.getGenerateBy() instanceof DataItemDesign && (design = (DataItemDesign)data.getGenerateBy()).getMap() == null && (valueExpr = ExpressionUtil.createJSRowExpression(column = design.getBindingColumn())) != null) {
                try {
                    Object dataValue = ReportContentLoaderV2.this.context.evaluate(valueExpr);
                    data.setValue(dataValue);
                }
                catch (BirtException ex) {
                    ReportContentLoaderV2.this.context.addException(ex);
                }
            }
            emitter.startData(data);
            return value;
        }

        public Object visitImage(IImageContent image, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startImage(image);
            return value;
        }

        public Object visitForeign(IForeignContent content, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startForeign(content);
            return value;
        }

        public Object visitList(IListContent list, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startList(list);
            return value;
        }

        public Object visitListBand(IListBandContent listBand, Object value) throws BirtException {
            this.setupGroupBand(listBand);
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startListBand(listBand);
            return value;
        }

        protected void setupGroupBand(IBandContent bandContent) throws BirtException {
        }

        public Object visitGroup(IGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startGroup(group);
            return value;
        }

        public Object visitListGroup(IListGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startListGroup(group);
            return value;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTableGroup(group);
            return value;
        }
    };
    protected IContentVisitor outputEndVisitor = new IContentVisitor(){

        public Object visit(IContent content, Object value) throws BirtException {
            return content.accept(this, value);
        }

        public Object visitContent(IContent content, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endContent(content);
            return value;
        }

        public Object visitPage(IPageContent page, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endPage(page);
            return value;
        }

        public Object visitContainer(IContainerContent container, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endContainer(container);
            return value;
        }

        public Object visitTable(ITableContent table, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTable(table);
            return value;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTableBand(tableBand);
            return value;
        }

        public Object visitRow(IRowContent row, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endRow(row);
            return value;
        }

        public Object visitCell(ICellContent cell, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endCell(cell);
            return value;
        }

        public Object visitText(ITextContent text, Object value) {
            return value;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            return value;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            return value;
        }

        public Object visitData(IDataContent data, Object value) {
            return value;
        }

        public Object visitImage(IImageContent image, Object value) {
            return value;
        }

        public Object visitForeign(IForeignContent content, Object value) {
            return value;
        }

        public Object visitList(IListContent list, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endList(list);
            return value;
        }

        public Object visitListBand(IListBandContent listBand, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endListBand(listBand);
            return value;
        }

        public Object visitGroup(IGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endGroup(group);
            return value;
        }

        public Object visitListGroup(IListGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endListGroup(group);
            return value;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTableGroup(group);
            return value;
        }
    };

    public ReportContentLoaderV2(ExecutionContext context) throws EngineException {
        this.context = context;
        this.dataEngine = context.getDataEngine();
        this.report = context.getReport();
        this.reportContent = (ReportContent)ContentFactory.createReportContent(this.report);
        this.reportContent.setExecutionContext(context);
        context.setReportContent(this.reportContent);
        this.dummyReportContent = this.reportContent.createLabelContent();
        this.dummyReportContent.setStyleClass(this.report.getRootStyleName());
        this.reportDoc = context.getReportDocument();
        this.dataEngine.prepare(this.report, context.getAppContext());
        IEngineTask engineTask = context.getEngineTask();
        if (engineTask instanceof RenderTask) {
            RenderTask renderTask = (RenderTask)engineTask;
            ITreeNode tocTree = renderTask.getRawTOCTree();
            this.reportContent.setTOCTree(tocTree);
        }
    }

    protected void openReaders() {
        try {
            this.reader = new ReportContentReaderV2(this.reportContent, this.reportDoc, this.context.getApplicationClassLoader());
            this.reader.open("/content/content.dat");
            this.pageReader = new ReportContentReaderV2(this.reportContent, this.reportDoc, this.context.getApplicationClassLoader());
            this.pageReader.open("/content/page.dat");
            this.hintReader = new PageHintReaderV2(this.reportDoc.getArchive());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to open the content reader", ex);
            this.closeReaders();
        }
    }

    protected void closeReaders() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.pageReader != null) {
            this.pageReader.close();
            this.pageReader = null;
        }
        if (this.hintReader != null) {
            this.hintReader.close();
            this.hintReader = null;
        }
    }

    public void loadPage(long pageNumber, int paginationType, IContentEmitter emitter) throws BirtException {
        boolean bodyOnly = paginationType == 0 || paginationType == 2;
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            try {
                this.openReaders();
                this.excutePage(pageNumber, bodyOnly);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to load the page", ex);
                emitter.end(this.reportContent);
                this.closeReaders();
            }
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    public void loadReportlet(long offset, IContentEmitter emitter) throws BirtException {
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            try {
                this.openReaders();
                this.excuteReportlet(offset);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to load the page", ex);
                emitter.end(this.reportContent);
                this.closeReaders();
            }
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    protected IPageHint loadPageHint(long pageNumber) {
        try {
            return this.hintReader.getPageHint(pageNumber);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Failed to load page hint " + pageNumber, ex);
            return null;
        }
    }

    private void excutePage(long pageNumber, boolean bodyOnly) throws BirtException {
        IPageHint pageHint = this.loadPageHint(pageNumber);
        if (pageHint == null) {
            return;
        }
        IPageContent pageContent = null;
        if (!bodyOnly) {
            long pageOffset = pageHint.getOffset();
            try {
                pageContent = this.loadPageContent(pageOffset);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can not load the page content " + pageNumber, ex);
            }
            if (pageContent == null) {
                return;
            }
            Object generateBy = pageContent.getGenerateBy();
            if (generateBy instanceof SimpleMasterPageDesign) {
                SimpleMasterPageDesign pageDesign = (SimpleMasterPageDesign)generateBy;
                if (!pageDesign.isShowHeaderOnFirst() && pageNumber == 1L) {
                    pageContent.getHeader().clear();
                }
                if (!pageDesign.isShowFooterOnLast() && pageNumber == this.reportDoc.getPageCount()) {
                    pageContent.getFooter().clear();
                }
            }
            this.emitter.startPage(pageContent);
        }
        int i = 0;
        while (i < pageHint.getSectionCount()) {
            PageSection section = pageHint.getSection(i);
            long start = section.startOffset;
            long end = section.endOffset;
            if (start != -1L && end != -1L) {
                try {
                    this.outputPageRegion(start, end);
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "Can not load the page content");
                }
            }
            ++i;
        }
        while (!this.contents.isEmpty()) {
            IContent content = (IContent)this.contents.pop();
            this.endContent(content, this.emitter);
        }
        if (!bodyOnly) {
            this.emitter.endPage(pageContent);
        }
    }

    private void excuteReportlet(long offset) throws BirtException {
        try {
            this.reader.setOffset(offset);
            IContent root = this.reader.readContent();
            IContent parent = (IContent)root.getParent();
            if (parent != null) {
                this.outputParent(parent);
            }
            this.initializeContent(root);
            this.startContent(root, this.emitter);
            this.contents.push(root);
            parent = root;
            IContent next = this.reader.readContent();
            while (next != null) {
                if (next.getParent() == parent) {
                    this.initializeContent(next);
                    this.startContent(next, this.emitter);
                    this.contents.push(next);
                    parent = next;
                    next = this.reader.readContent();
                    continue;
                }
                if (parent != root) {
                    this.endContent(parent, this.emitter);
                    this.contents.pop();
                    parent = (IContent)parent.getParent();
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Can not load the page content", ex);
        }
        while (!this.contents.isEmpty()) {
            IContent content = (IContent)this.contents.pop();
            this.endContent(content, this.emitter);
        }
    }

    private void outputPageRegion(long start, long end) throws IOException, BirtException {
        long offset = start;
        this.reader.setOffset(offset);
        while (offset <= end) {
            IContent content = this.reader.readContent();
            while (!this.contents.isEmpty()) {
                IContent parent = (IContent)this.contents.peek();
                if (parent == content.getParent()) break;
                this.endContent(parent, this.emitter);
                this.contents.pop();
            }
            if (this.contents.isEmpty()) {
                long curOffset = this.reader.getOffset();
                IContent parent = (IContent)content.getParent();
                if (parent != null) {
                    this.outputParent(parent);
                }
                this.reader.setOffset(curOffset);
            }
            this.initializeContent(content);
            this.startContent(content, this.emitter);
            this.contents.push(content);
            offset = this.reader.getOffset();
        }
    }

    private void outputParent(IContent content) throws IOException, BirtException {
        ITableContent table;
        IContent parent = (IContent)content.getParent();
        if (parent != null && parent != this.dummyReportContent) {
            this.outputParent(parent);
        }
        this.initializeContent(content);
        this.startContent(content, this.emitter);
        this.contents.push(content);
        if (content instanceof ITableContent && (table = (ITableContent)content).isHeaderRepeat()) {
            ITableBandContent header = table.getHeader();
            if (header == null) {
                long offset = this.getIndex(table);
                this.reader.setOffset(offset);
                this.reader.readContent();
                IContent headerContent = this.reader.readContent();
                this.loadFullContent(headerContent, this.reader);
                table.getChildren().add(headerContent);
                header = table.getHeader();
            }
            if (header != null) {
                new ContentDOMVisitor().emit(header, this.emitter);
            }
        }
    }

    public void loadPageRange(List pageList, int paginationType, IContentEmitter emitter) throws BirtException {
        boolean bodyOnly = paginationType == 0 || paginationType == 2;
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            try {
                this.openReaders();
                int m = 0;
                while (m < pageList.size()) {
                    long[] ps = (long[])pageList.get(m);
                    long i = ps[0];
                    while (i <= ps[1]) {
                        this.excutePage(i, bodyOnly);
                        ++i;
                    }
                    ++m;
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to load the page", ex);
                emitter.end(this.reportContent);
                this.closeReaders();
            }
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    protected IPageContent loadPageContent(long offset) throws IOException, BirtException {
        this.pageReader.setOffset(offset);
        IPageContent pageContent = (IPageContent)this.pageReader.readContent();
        this.initializeContent(pageContent);
        if (pageContent == null) {
            return null;
        }
        SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)pageContent.getGenerateBy();
        if (masterPage.getHeaderCount() > 0 || masterPage.getFooterCount() > 0) {
            IContent nextContent = null;
            IContent content = this.pageReader.readContent();
            int i = 0;
            while (i < masterPage.getHeaderCount()) {
                nextContent = this.loadFullContent(content, this.pageReader);
                pageContent.getHeader().add(content);
                content = nextContent;
                ++i;
            }
            i = 0;
            while (i < masterPage.getFooterCount()) {
                nextContent = this.loadFullContent(content, this.pageReader);
                pageContent.getFooter().add(content);
                content = nextContent;
                ++i;
            }
        }
        return pageContent;
    }

    protected IContent loadFullContent(IContent root, ReportContentReaderV2 reader) throws BirtException {
        DOMBuilderEmitter emitter = new DOMBuilderEmitter(root);
        IContent parent = root;
        this.initializeContent(root);
        try {
            this.openQuery(root);
            IContent next = reader.readContent();
            while (next != null) {
                if (next.getParent() == parent) {
                    this.initializeContent(next);
                    this.startContent(next, emitter);
                    parent = next;
                    next = reader.readContent();
                    continue;
                }
                if (parent == root) {
                    this.closeQuery(root);
                    return next;
                }
                this.endContent(parent, emitter);
                parent = (IContent)parent.getParent();
            }
        }
        catch (IOException iOException) {
        }
        catch (BirtException birtException) {}
        while (parent != root) {
            this.endContent(parent, emitter);
            parent = (IContent)parent.getParent();
        }
        this.closeQuery(root);
        return null;
    }

    protected void initializeContent(IContent content) {
        long designId;
        InstanceID id;
        content.setReportContent(this.reportContent);
        IElement parent = content.getParent();
        if (parent == null) {
            content.setParent(this.dummyReportContent);
        }
        if ((id = content.getInstanceID()) != null && (designId = id.getComponentID()) != -1L) {
            ReportElementDesign generateBy = this.findReportItem(designId);
            content.setGenerateBy(generateBy);
        }
    }

    protected ReportElementDesign findReportItem(long designId) {
        return this.report.getReportItemByID(designId);
    }

    protected void openQuery(IContent content) throws BirtException {
        InstanceID iid;
        ReportItemDesign design;
        IDataQueryDefinition query;
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportItemDesign && (query = (design = (ReportItemDesign)generateBy).getQuery()) != null) {
            DataSetID dataSetId;
            DataID dataId;
            InstanceID iid2 = content.getInstanceID();
            if (iid2 != null && (dataId = iid2.getDataID()) != null && (dataSetId = dataId.getDataSetID()) != null) {
                IQueryResultSet rset;
                DataSetID parentSetId = dataSetId.getParentID();
                long parentRowId = dataSetId.getRowID();
                if (parentSetId != null && parentRowId != -1L && !this.resultSets.isEmpty() && (rset = (IQueryResultSet)this.resultSets.peek()) != null && parentRowId != rset.getRowIndex()) {
                    rset.skipTo(parentRowId);
                }
            }
            IQueryResultSet rset = (IQueryResultSet)this.dataEngine.execute(query);
            this.resultSets.push(rset);
        }
        if ((iid = content.getInstanceID()) != null) {
            long rowId;
            IQueryResultSet rset;
            DataID dataId = iid.getDataID();
            while (dataId == null && iid.getParentID() != null) {
                iid = iid.getParentID();
                dataId = iid.getDataID();
            }
            if (dataId != null && !this.resultSets.isEmpty() && (rset = (IQueryResultSet)this.resultSets.peek()) != null && (rowId = dataId.getRowID()) != -1L && rowId != rset.getRowIndex()) {
                rset.skipTo(rowId);
            }
        }
    }

    protected void checkDataSet(DataID dataId, IQueryResultSet rset) {
        DataSetID dsetId = rset.getID();
        DataSetID rsetId = dataId.getDataSetID();
        assert (dsetId != null);
        assert (rsetId != null);
        assert (dsetId.toString().equals(rsetId.toString()));
    }

    protected void closeQuery(IContent content) {
        IQueryResultSet rset;
        ReportItemDesign design;
        IDataQueryDefinition query;
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportItemDesign && (query = (design = (ReportItemDesign)generateBy).getQuery()) != null && (rset = (IQueryResultSet)this.resultSets.pop()) != null) {
            rset.close();
        }
    }

    protected void startContent(IContent content, IContentEmitter emitter) throws BirtException {
        try {
            this.openQuery(content);
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        this.outputStartVisitor.visit(content, emitter);
    }

    protected void endContent(IContent content, IContentEmitter emitter) throws BirtException {
        this.outputEndVisitor.visit(content, emitter);
        this.closeQuery(content);
    }

    long getIndex(IContent content) {
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt != null) {
            return docExt.getIndex();
        }
        return -1L;
    }
}

