/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.EngineIRReaderImpl;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.IOConstants;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class EngineIRReader
implements IOConstants {
    protected boolean checkDesignVersion = false;
    protected DataInputStream dis;
    protected EngineIRReaderImpl reader;

    public EngineIRReader() {
    }

    public EngineIRReader(boolean checkDesignVersion) {
        this.checkDesignVersion = checkDesignVersion;
    }

    public Report read(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        long version = IOUtil.readLong(dis);
        if (version != 7L && version != 8L && (version < 0L || version > 4L)) {
            throw new IOException("unsupported version:" + version);
        }
        this.reader = new EngineIRReaderImpl(dis, this.checkDesignVersion);
        this.reader.version = version;
        return this.reader.read();
    }

    public void link(Report report, ReportDesignHandle handle) {
        new ReportItemVisitor(handle, report).link();
    }

    protected static class ReportItemVisitor
    extends DefaultReportItemVisitorImpl {
        ReportDesignHandle handle;
        Report report;

        ReportItemVisitor(ReportDesignHandle handle, Report report) {
            this.handle = handle;
            this.report = report;
        }

        public void link() {
            this.report.setReportDesign(this.handle);
            PageSetupDesign pageSetup = this.report.getPageSetup();
            int masterPageCount = pageSetup.getMasterPageCount();
            int i = 0;
            while (i < masterPageCount) {
                ReportItemDesign item;
                SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)pageSetup.getMasterPage(i);
                this.linkReportElement(masterPage);
                int count = masterPage.getHeaderCount();
                int j = 0;
                while (j < count) {
                    item = masterPage.getHeader(j);
                    item.accept(this, null);
                    ++j;
                }
                count = masterPage.getFooterCount();
                j = 0;
                while (j < count) {
                    item = masterPage.getFooter(j);
                    item.accept(this, null);
                    ++j;
                }
                ++i;
            }
            int count = this.report.getContentCount();
            int i2 = 0;
            while (i2 < count) {
                ReportItemDesign item = this.report.getContent(i2);
                item.accept(this, null);
                ++i2;
            }
            this.linkReportDesign(this.report);
        }

        private void linkReportDesign(Report design) {
            this.setupScriptID(design);
        }

        private void setupScriptID(Report design) {
            String id;
            ReportDesignHandle designHandle = design.getReportDesign();
            Expression scriptExpr = design.getOnPageStart();
            if (scriptExpr != null && scriptExpr.getType() == 1) {
                id = ModuleUtil.getScriptUID(designHandle.getPropertyHandle("onPageStart"));
                ((Expression.Script)scriptExpr).setFileName(id);
            }
            if ((scriptExpr = design.getOnPageEnd()) != null && scriptExpr.getType() == 1) {
                id = ModuleUtil.getScriptUID(designHandle.getPropertyHandle("onPageEnd"));
                ((Expression.Script)scriptExpr).setFileName(id);
            }
        }

        protected void linkReportElement(ReportElementDesign element) {
            DesignElementHandle currentView;
            long id = element.getID();
            DesignElementHandle elementHandle = this.handle.getElementByID(id);
            if (elementHandle instanceof ReportItemHandle && (currentView = ((ReportItemHandle)elementHandle).getCurrentView()) != null) {
                elementHandle = currentView;
            }
            element.setHandle(elementHandle);
            this.setupScriptID(element);
            this.report.setReportItemInstanceID(id, element);
        }

        private void setupScriptID(ReportElementDesign element) {
            ReportItemDesign item;
            DesignElementHandle elementHandle;
            if (element instanceof ReportItemDesign && (elementHandle = (item = (ReportItemDesign)element).getHandle()) != null) {
                String id;
                Expression scriptExpr = item.getOnRender();
                if (scriptExpr != null && scriptExpr.getType() == 1) {
                    id = ModuleUtil.getScriptUID(elementHandle.getPropertyHandle("onRender"));
                    ((Expression.Script)scriptExpr).setFileName(id);
                }
                if ((scriptExpr = item.getOnCreate()) != null && scriptExpr.getType() == 1) {
                    id = ModuleUtil.getScriptUID(elementHandle.getPropertyHandle("onCreate"));
                    ((Expression.Script)scriptExpr).setFileName(id);
                }
                if ((scriptExpr = item.getOnPageBreak()) != null && scriptExpr.getType() == 1) {
                    id = ModuleUtil.getScriptUID(elementHandle.getPropertyHandle("onPageBreak"));
                    ((Expression.Script)scriptExpr).setFileName(id);
                }
            }
        }

        public Object visitBand(BandDesign band, Object value) {
            this.linkReportElement(band);
            int count = band.getContentCount();
            int i = 0;
            while (i < count) {
                ReportItemDesign item = band.getContent(i);
                item.accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            this.linkReportElement(cell);
            int count = cell.getContentCount();
            int i = 0;
            while (i < count) {
                ReportItemDesign item = cell.getContent(i);
                item.accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            this.linkReportElement(container);
            int count = container.getItemCount();
            int i = 0;
            while (i < count) {
                ReportItemDesign item = container.getItem(i);
                item.accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            this.linkReportElement(grid);
            int count = grid.getColumnCount();
            int i = 0;
            while (i < count) {
                ColumnDesign column = grid.getColumn(i);
                this.linkReportElement(column);
                ++i;
            }
            count = grid.getRowCount();
            i = 0;
            while (i < count) {
                RowDesign item = grid.getRow(i);
                ((ReportItemDesign)item).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitGroup(GroupDesign group, Object value) {
            BandDesign footer;
            this.linkReportElement(group);
            BandDesign header = group.getHeader();
            if (header != null) {
                header.accept(this, value);
            }
            if ((footer = group.getFooter()) != null) {
                footer.accept(this, value);
            }
            return value;
        }

        public Object visitListing(ListingDesign listing, Object value) {
            BandDesign footer;
            this.linkReportElement(listing);
            BandDesign header = listing.getHeader();
            if (header != null) {
                header.accept(this, value);
            }
            int count = listing.getGroupCount();
            int i = 0;
            while (i < count) {
                GroupDesign group = listing.getGroup(i);
                group.accept(this, value);
                ++i;
            }
            BandDesign detail = listing.getDetail();
            if (detail != null) {
                detail.accept(this, null);
            }
            if ((footer = listing.getFooter()) != null) {
                footer.accept(this, value);
            }
            return value;
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            this.visitListing(table, value);
            int count = table.getColumnCount();
            int i = 0;
            while (i < count) {
                ColumnDesign column = table.getColumn(i);
                this.linkReportElement(column);
                ++i;
            }
            return value;
        }

        public Object visitReportItem(ReportItemDesign item, Object value) {
            this.linkReportElement(item);
            return value;
        }

        public Object visitRow(RowDesign row, Object value) {
            this.linkReportElement(row);
            int count = row.getCellCount();
            int i = 0;
            while (i < count) {
                CellDesign cell = row.getCell(i);
                cell.accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitExtendedItem(ExtendedItemDesign extendedItem, Object value) {
            this.linkReportElement(extendedItem);
            List children = extendedItem.getChildren();
            int i = 0;
            while (i < children.size()) {
                ((ReportItemDesign)children.get(i)).accept(this, null);
                ++i;
            }
            return value;
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            this.linkReportElement(image);
            if (image.getImageSource() == 1 && image.getImageName() == null) {
                ImageHandle imageHandle = (ImageHandle)image.getHandle();
                image.setImageName(Expression.newConstant(imageHandle.getImageName()));
            }
            return value;
        }
    }
}

