/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.api.script.IScriptDataSourceEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IScriptedDataSetEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IScriptedDataSourceEventHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DataSourceScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.instance.DataSourceInstance;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;

public class ScriptDataSourceScriptExecutor
extends DataSourceScriptExecutor
implements IScriptDataSourceEventHandler {
    private static final String OPEN = "OPEN";
    private static final String CLOSE = "CLOSE";
    private IScriptedDataSourceEventHandler scriptedEventHandler;

    public ScriptDataSourceScriptExecutor(ScriptDataSourceHandle dataSourceHandle, ExecutionContext context) throws BirtException {
        super(dataSourceHandle, context);
    }

    protected void initEventHandler() {
        super.initEventHandler();
        if (this.eventHandler != null) {
            try {
                this.scriptedEventHandler = (IScriptedDataSourceEventHandler)this.eventHandler;
            }
            catch (ClassCastException e) {
                ScriptDataSourceScriptExecutor.addClassCastException(this.context, e, this.dataSourceHandle, IScriptedDataSetEventHandler.class);
            }
        }
    }

    public void handleOpen(IDataSourceInstanceHandle dataSource) {
        this.initEventHandler();
        try {
            String id = ModuleUtil.getScriptUID(this.dataSourceHandle.getPropertyHandle("open"));
            ScriptExecutor.ScriptStatus status = super.handleJS(dataSource.getScriptScope(), dataSource.getName(), OPEN, ((ScriptDataSourceHandle)this.dataSourceHandle).getOpen(), id);
            if (status.didRun()) {
                return;
            }
            if (this.scriptedEventHandler != null) {
                this.scriptedEventHandler.open(new DataSourceInstance(dataSource));
            }
        }
        catch (Exception e) {
            ScriptDataSourceScriptExecutor.addException(this.context, e);
        }
    }

    public void handleClose(IDataSourceInstanceHandle dataSource) {
        this.initEventHandler();
        try {
            String id = ModuleUtil.getScriptUID(this.dataSourceHandle.getPropertyHandle("close"));
            ScriptExecutor.ScriptStatus status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), CLOSE, ((ScriptDataSourceHandle)this.dataSourceHandle).getClose(), id);
            if (status.didRun()) {
                return;
            }
            if (this.scriptedEventHandler != null) {
                this.scriptedEventHandler.close(new DataSourceInstance(dataSource));
            }
        }
        catch (Exception e) {
            ScriptDataSourceScriptExecutor.addException(this.context, e);
        }
    }
}

