/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.model.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.report.model.adapter.oda.model.DataSetParameters;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.DocumentRoot;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.model.Serializer;
import org.eclipse.birt.report.model.adapter.oda.model.util.ModelXMLProcessor;
import org.eclipse.birt.report.model.adapter.oda.model.util.SchemaConversionUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class SerializerImpl
implements Serializer {
    private static Serializer sz = null;

    private SerializerImpl() {
    }

    public static final synchronized Serializer instance() {
        if (sz == null) {
            sz = new SerializerImpl();
        }
        return sz;
    }

    public void write(DesignValues cModel, OutputStream os) throws IOException {
        DocumentRoot documentRoot = ModelFactory.eINSTANCE.createDocumentRoot();
        documentRoot.setDesignValues(cModel);
        cModel.setVersion("2.0");
        ModelXMLProcessor xmlProcessor = new ModelXMLProcessor();
        Resource resource = xmlProcessor.createResource(URI.createFileURI((String)"test.designValue"));
        resource.getContents().add((Object)documentRoot);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(os, options);
    }

    protected DesignValues read(InputStream is) throws IOException {
        ModelXMLProcessor xmlProcessor = new ModelXMLProcessor();
        Resource resource = xmlProcessor.createResource(URI.createFileURI((String)"test.designValue"));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.load(is, options);
        DocumentRoot docRoot = (DocumentRoot)resource.getContents().get(0);
        return docRoot.getDesignValues();
    }

    public DesignValues read(String values) throws IOException {
        if (values == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(values.getBytes("utf-8"));
        DesignValues retValues = this.read(bis);
        bis.close();
        this.convertDesignParametersToAdapterParameters(retValues);
        return retValues;
    }

    private void convertDesignParametersToAdapterParameters(DesignValues retValues) {
        if (retValues == null) {
            return;
        }
        org.eclipse.datatools.connectivity.oda.design.DataSetParameters designParams = retValues.getDataSetParameters1();
        if (designParams == null || designParams.eContents().isEmpty()) {
            return;
        }
        String version = retValues.getVersion();
        float floatVersion = Float.parseFloat(version);
        if ((double)floatVersion > 1.5) {
            return;
        }
        DataSetParameters adapterParams = SchemaConversionUtil.convertToAdapterParameters(designParams);
        retValues.setDataSetParameters(adapterParams);
        retValues.setDataSetParameters1(null);
        retValues.setVersion("2.0");
    }

    public String write(DesignValues values) throws IOException {
        if (values == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.write(values, bos);
        String retValue = bos.toString("utf-8");
        bos.close();
        return retValue;
    }
}

