/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ElementLocalizeEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ElementLocalizeRecord
extends SimpleRecord {
    private Module module = null;
    private DesignElement element = null;
    private DesignElement parent = null;
    private long baseId;
    private Map<String, Object> propValues = new HashMap<String, Object>();

    public ElementLocalizeRecord(Module module, DesignElement virtualChild, DesignElement virtualParent) {
        assert (virtualChild.isVirtualElement());
        assert (virtualChild.getBaseId() == virtualParent.getID());
        assert (virtualChild.getDefn() == virtualParent.getDefn());
        this.module = module;
        this.element = virtualChild;
        this.parent = virtualParent;
        this.baseId = virtualChild.getBaseId();
        this.collectOverriddenProperties();
    }

    private void collectOverriddenProperties() {
        assert (this.element != null);
        for (PropertyDefn propertyDefn : this.element.getPropertyDefns()) {
            Object value;
            if ("extends".equals(propertyDefn.getName()) || (value = this.element.getLocalProperty(this.module, propertyDefn.getName())) == null) continue;
            this.propValues.put(propertyDefn.getName(), value);
        }
    }

    private void localizeElement(DesignElement from, DesignElement to) {
        for (ElementPropertyDefn elementPropertyDefn : from.getDefn().getProperties()) {
            String propName = elementPropertyDefn.getName();
            if (!elementPropertyDefn.canInherit() || "style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName)) continue;
            Object localValue = to.getLocalProperty(this.module, elementPropertyDefn);
            Object parentValue = from.getStrategy().getPropertyFromElement(this.module, from, elementPropertyDefn);
            if (localValue != null || parentValue == null) continue;
            Object valueToSet = ModelUtil.copyValue(elementPropertyDefn, parentValue);
            to.setProperty(elementPropertyDefn, valueToSet);
        }
    }

    private void recoverProperties(DesignElement obj) {
        obj.clearAllProperties();
        for (String propName : this.propValues.keySet()) {
            assert (!"extends".equals(propName));
            if ("style".equals(propName)) {
                ElementRefValue refValue = (ElementRefValue)this.propValues.get(propName);
                if (refValue == null) continue;
                if (refValue.isResolved()) {
                    ((StyledElement)obj).setStyle((Style)refValue.getElement());
                    continue;
                }
                ((StyledElement)obj).setStyleName(refValue.getName());
                continue;
            }
            obj.setProperty(propName, this.propValues.get(propName));
        }
    }

    protected void perform(boolean undo) {
        if (undo) {
            this.recoverProperties(this.element);
            this.element.setBaseId(this.baseId);
        } else {
            this.localizeElement(this.parent, this.element);
            this.element.setBaseId(-1L);
        }
    }

    public DesignElement getTarget() {
        return this.element;
    }

    public NotificationEvent getEvent() {
        return new ElementLocalizeEvent(this.element);
    }
}

