/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.birt.report.model.api.ModelException;

public class MetaDataException
extends ModelException {
    private static final long serialVersionUID = 3787774664483885333L;
    protected Properties props = null;
    protected static final String ERROR_FILE = "MetaError.properties";
    protected String message = null;
    public static final String DESIGN_EXCEPTION_INVALID_NAME_SPACE = "INVALID_NAME_SPACE";
    public static final String DESIGN_EXCEPTION_ENCYRPTION_EXTENSION_EXISTS = "ENCYRPTION_EXTENSION_EXISTS";
    public static final String DESIGN_EXCEPTION_MISSING_ELEMENT_NAME = "MISSING_ELEMENT_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_ELEMENT_NAME = "DUPLICATE_ELEMENT_NAME";
    public static final String DESIGN_EXCEPTION_MISSING_EXTENSION_NAME = "MISSING_EXTENSION_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_EXTENSION_NAME = "DUPLICATE_EXTENSION_NAME";
    public static final String DESIGN_EXCEPTION_MISSING_STYLE_NAME = "MISSING_STYLE_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_STYLE_NAME = "DUPLICATE_STYLE_NAME";
    public static final String DESIGN_EXCEPTION_STYLE_TYPE_MISSING = "STYLE_TYPE_MISSING";
    public static final String DESIGN_EXCEPTION_EXTENDED_ITEM_MISSING = "EXTENDED_ITEM_MISSING";
    public static final String DESIGN_EXCEPTION_REPORT_MISSING = "REPORT_MISSING";
    public static final String DESIGN_EXCEPTION_STYLE_NOT_DEFINED = "STYLE_NOT_DEFINED";
    public static final String DESIGN_EXCEPTION_DUPLICATE_PROPERTY = "DUPLICATE_PROPERTY";
    public static final String DESIGN_EXCEPTION_ELEMENT_PARENT_NOT_FOUND = "ELEMENT_PARENT_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_ILLEGAL_STYLE_PROPS = "ILLEGAL_STYLE_PROPS";
    public static final String DESIGN_EXCEPTION_ILLEGAL_ABSTRACT_ELEMENT = "ILLEGAL_ABSTRACT_ELEMENT";
    public static final String DESIGN_EXCEPTION_INVALID_NAME_OPTION = "INVALID_NAME_OPTION";
    public static final String DESIGN_EXCEPTION_INVALID_STYLE_PROP_OPTION = "INVALID_STYLE_PROP_OPTION";
    public static final String DESIGN_EXCEPTION_STYLE_PROP_NOT_FOUND = "STYLE_PROP_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_PROP_TYPE_ERROR = "PROP_TYPE_ERROR";
    public static final String DESIGN_EXCEPTION_MISSING_PROP_CHOICES = "MISSING_PROP_CHOICES";
    public static final String DESIGN_EXCEPTION_MISSING_SLOT_TYPE = "MISSING_SLOT_TYPE";
    public static final String DESIGN_EXCEPTION_MISSING_SLOT_NAME = "MISSING_SLOT_NAME";
    public static final String DESIGN_EXCEPTION_INVALID_SLOT_TYPE = "INVALID_SLOT_TYPE";
    public static final String DESIGN_EXCEPTION_ELEMENT_NAME_CONST = "ELEMENT_NAME_CONST";
    public static final String DESIGN_EXCEPTION_MISSING_CHOICE_SET_NAME = "MISSING_CHOICE_SET_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_CHOICE_NAME = "DUPLICATE_CHOICE_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_CHOICE_SET_NAME = "DUPLICATE_CHOICE_SET_NAME";
    public static final String DESIGN_EXCEPTION_VISIBILITY_PROPERTY_NOT_FOUND = "VISIBILITY_PROPERTY_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_MISSING_STRUCT_NAME = "MISSING_STRUCT_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_STRUCT_NAME = "DUPLICATE_STRUCT_NAME";
    public static final String DESIGN_EXCEPTION_MISSING_STRUCT_DEFN = "MISSING_STRUCT_DEFN";
    public static final String DESIGN_EXCEPTION_UNREFERENCABLE_STRUCT_DEFN = "UNREFERENCABLE_STRUCT_DEFN";
    public static final String DESIGN_EXCEPTION_MISSING_ELEMENT_TYPE = "MISSING_ELEMENT_TYPE";
    public static final String DESIGN_EXCEPTION_UNDEFINED_ELEMENT_TYPE = "UNDEFINED_ELEMENT_TYPE";
    public static final String DESIGN_EXCEPTION_UNNAMED_ELEMENT_TYPE = "UNNAMED_ELEMENT_TYPE";
    public static final String DESIGN_EXCEPTION_INCONSISTENT_PROP_TYPE = "INCONSISTENT_PROP_TYPE";
    public static final String DESIGN_EXCEPTION_MISSING_JAVA_CLASS = "MISSING_JAVA_CLASS";
    public static final String DESIGN_EXCEPTION_JAVA_CLASS_INITIALIZE_ERROR = "JAVA_CLASS_INITIALIZE_ERROR";
    public static final String DESIGN_EXCEPTION_JAVA_CLASS_LOAD_ERROR = "JAVA_CLASS_LOAD_ERROR";
    public static final String DESIGN_EXCEPTION_INVALID_ELEMENT_JAVA_CLASS = "INVALID_ELEMENT_JAVA_CLASS";
    public static final String DESIGN_EXCEPTION_MISSING_METHOD_NAME = "MISSING_METHOD_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_METHOD_NAME = "DUPLICATE_METHOD_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_ARGUMENT_NAME = "DUPLICATE_ARGUMENT_NAME";
    public static final String DESIGN_EXCEPTION_INVALID_DEFAULT_VALUE = "INVALID_DEFAULT_VALUE";
    public static final String DESIGN_EXCEPTION_MISSING_CLASS_NAME = "MISSING_CLASS_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_CLASS_NAME = "DUPLICATE_CLASS_NAME";
    public static final String DESIGN_EXCEPTION_CONSTRUCTOR_EXISTING = "CONSTRUCTOR_EXISTING";
    public static final String DESIGN_EXCEPTION_DUPLICATE_MEMBER_NAME = "DUPLICATE_MEMBER_NAME";
    public static final String DESIGN_EXCEPTION_MISSING_MEMBER_NAME = "MISSING_MEMBER_NAME";
    public static final String DESIGN_EXCEPTION_INVALID_LIST_TYPE = "INVALID_LIST_TYPE";
    public static final String DESIGN_EXCEPTION_MISSING_VALIDATOR_NAME = "MISSING_VALIDATOR_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_VALIDATOR_NAME = "DUPLICATE_VALIDATOR_NAME";
    public static final String DESIGN_EXCEPTION_VALIDATOR_NOT_FOUND = "VALIDATOR_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_INVALID_PROPERTY_TYPE = "INVALID_PROPERTY_TYPE";
    public static final String DESIGN_EXCEPTION_INVALID_UNIT = "INVALID_UNIT";
    public static final String DESIGN_EXCEPTION_MISSING_SUB_TYPE = "MISSING_SUB_TYPE";
    public static final String DESIGN_EXCEPTION_UNSUPPORTED_SUB_TYPE = "UNSUPPORTED_SUB_TYPE";
    public static final String DESIGN_EXCEPTION_SUB_TYPE_FORBIDDEN = "SUB_TYPE_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_MISSING_XML_NAME = "MISSING_XML_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_XML_NAME = "DUPLICATE_XML_NAME";

    public MetaDataException(String[] params, String errCode) {
        this(params, errCode, null);
    }

    public MetaDataException(String[] params, String errCode, Throwable cause) {
        super(errCode, params, (Throwable)null);
        if (this.props == null) {
            this.props = this.loadResourceFile(ERROR_FILE);
        }
        if (this.props != null) {
            String msg = this.props.getProperty(errCode);
            assert (msg != null) : "Error information for error code: " + errCode + " not found in MetaError.properties.";
            this.message = params == null ? msg : MessageFormat.format(msg, params);
        }
    }

    public MetaDataException(String errCode) {
        this(null, errCode);
    }

    protected Properties loadResourceFile(String fileName) {
        Properties props = new Properties();
        try {
            InputStream in = MetaDataException.class.getResourceAsStream(fileName);
            props.load(in);
            in.close();
        }
        catch (IOException iOException) {
            props = null;
        }
        return props;
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        String SEPARATOR = " ";
        if (this.message != null) {
            sb.append("Message:").append(this.message).append(SEPARATOR);
        }
        sb.append("Error code:").append(this.sResourceKey).append(SEPARATOR);
        return sb.toString();
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }
}

