/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.core.namespace.ModuleNameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.css.CssNameManager;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.parser.ModuleParserErrorHandler;
import org.eclipse.birt.report.model.parser.RecoverDataGroupUtil;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleParserHandler
extends XMLParserHandler {
    protected DesignSessionImpl session = null;
    protected Module module = null;
    protected String fileName = null;
    int versionNumber = 0;
    boolean isCurrentVersion = false;
    protected boolean markLineNumber = true;
    protected HashMap<Object, Integer> tempLineNumbers = null;
    protected HashMap<Object, Object> tempValue = new HashMap();
    public List<DesignElement> unhandleIDElements = new ArrayList<DesignElement>();
    protected List<TabularDimension> unhandleCubeDimensions = new ArrayList<TabularDimension>();
    private List<DesignElement> unnamedReportItems = new ArrayList<DesignElement>();
    private List<ListingElement> unresolvedListingElements = new ArrayList<ListingElement>();
    private List<DesignElement> extendedItemList = new ArrayList<DesignElement>();
    protected Map<String, Library> reloadLibs = new HashMap<String, Library>();
    protected boolean isReadOnlyModuleProperties = false;
    protected List<DesignElement> styledElements = null;
    protected static final String PARAMETER_NAME_CACHE_KEY = "parameter_name_cache";

    protected ModuleParserHandler(DesignSessionImpl theSession, String fileName) {
        super(new ModuleParserErrorHandler());
        this.session = theSession;
        this.fileName = fileName;
    }

    protected ModuleParserHandler(DesignSessionImpl theSession, String fileName, Map<String, Library> reloadLibs) {
        super(new ModuleParserErrorHandler());
        this.session = theSession;
        this.fileName = fileName;
        this.reloadLibs = reloadLibs;
    }

    String getFileName() {
        return this.fileName;
    }

    public boolean isVersion(int toCompare) {
        return this.versionNumber == toCompare;
    }

    public Module getModule() {
        return this.module;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.errorHandler.setCurrentElement(qName);
        AbstractParseState newState = this.topState.startElement(qName);
        newState.parseAttrs(atts);
        AbstractParseState jumpToState = newState.jumpTo();
        if (jumpToState != null) {
            this.pushState(jumpToState);
            return;
        }
        newState.setElementName(qName);
        this.pushState(newState);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.doEndDocument();
    }

    public void doEndDocument() throws SAXException {
        ModuleOption options;
        List<XMLParserException> errors = this.getErrorHandler().getErrors();
        if (this.module == null) {
            DesignFileException e = null;
            if (errors.size() > 0) {
                e = new DesignFileException(this.fileName, errors);
            }
            throw new SAXException(e);
        }
        this.tempValue = null;
        if (this.versionNumber < 3021300) {
            List<Exception> handledExceptions = this.handleInvalidName(errors);
            errors.removeAll(handledExceptions);
        }
        this.handleUnresolveListingElements();
        this.module.getAllExceptions().addAll(errors);
        List<Library> libraries = this.module.getAllLibraries();
        for (Library library : libraries) {
            Exception fatalException;
            if (library.isValid() || (fatalException = ModelUtil.getFirstFatalException(library.getAllExceptions())) == null) continue;
            XMLParserException exception = this.errorHandler.semanticError(fatalException);
            this.module.getAllExceptions().add(exception);
        }
        if (!this.module.getAllErrors().isEmpty() || this.module.getFatalException() != null) {
            this.module.setValid(false);
            ArrayList<Exception> allExceptions = new ArrayList<Exception>();
            allExceptions.addAll(this.module.getAllExceptions());
            allExceptions.addAll(this.errorHandler.getWarnings());
            DesignFileException exception = new DesignFileException(this.module.getFileName(), allExceptions);
            throw new SAXException(exception);
        }
        if (!this.unhandleIDElements.isEmpty()) {
            this.handleID();
            this.unhandleIDElements = null;
        }
        if (!this.unhandleCubeDimensions.isEmpty()) {
            for (TabularDimension dimension : this.unhandleCubeDimensions) {
                dimension.updateLayout(this.module);
                this.module.manageId(dimension, true);
            }
            this.unhandleCubeDimensions = null;
        }
        if (!this.unnamedReportItems.isEmpty() && this.versionNumber <= 3021200) {
            this.handleUnnamedReportItems();
        }
        if (this.versionNumber <= 3021300 && StringUtil.isBlank(this.module.getNamespace())) {
            ((ModuleNameHelper)this.module.getNameHelper()).clearCachedLevels();
        }
        if (this.markLineNumber && this.tempLineNumbers != null) {
            this.handleLineNumber();
        }
        if (this.versionNumber < 3021900) {
            this.handleStyleNameCompatibilities();
        }
        if (this.versionNumber < 3022000) {
            this.handleVariableElementEmptyName();
        }
        if ((options = this.module.getOptions()) == null || options.useSemanticCheck()) {
            this.module.semanticCheck(this.module);
        }
        if (this.errorHandler.getWarnings() != null) {
            this.module.getAllExceptions().addAll(this.errorHandler.getWarnings());
        }
        if (!this.extendedItemList.isEmpty()) {
            this.module.getVersionManager().setHasExtensionCompatibilities(this.handleExtendedItemCompatibility());
        }
    }

    private void handleVariableElementEmptyName() {
        if (this.module instanceof ReportDesign) {
            ReportDesign design = (ReportDesign)this.module;
            List<Object> list = design.getListProperty(this.module, "pageVariables");
            if (list == null) {
                return;
            }
            int i = 0;
            while (i < list.size()) {
                VariableElement element = (VariableElement)list.get(i);
                String name = element.getName();
                if (StringUtil.isBlank(name)) {
                    this.module.makeUniqueName(element);
                }
                ++i;
            }
        }
    }

    private boolean handleExtendedItemCompatibility() {
        assert (!this.module.isReadOnly());
        List<Exception> errorList = this.module.getAllExceptions();
        boolean hasCompatibilities = false;
        int i = 0;
        while (i < this.extendedItemList.size()) {
            ExtendedItem element = (ExtendedItem)this.extendedItemList.get(i);
            ExtendedItem.StatusInfo status = element.checkCompatibility(this.module);
            assert (status != null);
            errorList.addAll(status.getErrors());
            if (!hasCompatibilities && status.hasCompatibilities()) {
                hasCompatibilities = true;
            }
            ++i;
        }
        this.module.getActivityStack().flush();
        this.module.setSaveState(0);
        return hasCompatibilities;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    private void handleID() {
        int i = 0;
        while (i < this.unhandleIDElements.size()) {
            DesignElement element = this.unhandleIDElements.get(i);
            if (element.getExtendsElement() == null && element.getDynamicExtendsElement(this.module) == null) {
                if (element.getRoot() == this.module) {
                    assert (element.getID() == 0L);
                    element.setID(this.module.getNextID());
                    this.module.addElementID(element);
                }
            } else {
                this.module.manageId(element, true);
            }
            ++i;
        }
    }

    private void handleUnnamedReportItems() {
        int i = 0;
        while (i < this.unnamedReportItems.size()) {
            DesignElement element = this.unnamedReportItems.get(i);
            ModelUtil.addElement2NameSpace(this.module, element);
            ++i;
        }
    }

    private List<Exception> handleInvalidName(List<? extends Exception> exceptions) {
        ArrayList<Exception> handledExceptions = new ArrayList<Exception>();
        ArrayList<DesignElement> processElements = new ArrayList<DesignElement>();
        int i = 0;
        while (i < exceptions.size()) {
            Exception exception;
            Exception tmpObj = exceptions.get(i);
            if (tmpObj instanceof XMLParserException && (exception = ((XMLParserException)tmpObj).getException()) instanceof NameException) {
                NameException nameException = (NameException)exception;
                DesignElement tmpElement = nameException.getElement();
                if (tmpElement.getName() != null && nameException.getErrorCode() == "Error.NameException.INVALID_NAME") {
                    String newName;
                    String oldName = nameException.getName();
                    if (!oldName.equals(newName = NamePropertyType.validateName(oldName))) {
                        tmpElement.setName(newName);
                        int ns = ((ElementDefn)tmpElement.getDefn()).getNameSpaceID();
                        if (ns != -1) {
                            new NameExecutor(tmpElement).getNameSpace(this.module).rename(tmpElement, oldName, newName);
                        }
                        processElements.add(tmpElement);
                        handledExceptions.add(tmpObj);
                    }
                } else if (processElements.contains(tmpElement)) {
                    handledExceptions.add(tmpObj);
                }
            }
            ++i;
        }
        return handledExceptions;
    }

    private void handleUnresolveListingElements() {
        int i = 0;
        while (i < this.unresolvedListingElements.size()) {
            ListingElement tmpElement = this.unresolvedListingElements.get(i);
            RecoverDataGroupUtil.checkListingGroup(tmpElement, this);
            ++i;
        }
    }

    private void handleLineNumber() {
        for (Map.Entry<Object, Integer> entry : this.tempLineNumbers.entrySet()) {
            Object key = entry.getKey();
            this.module.addLineNo(key, entry.getValue());
        }
        this.tempLineNumbers.clear();
        this.tempLineNumbers = null;
    }

    protected final void buildModuleOptions(ModuleOption options) {
        assert (this.module != null);
        if (options == null) {
            this.markLineNumber = true;
            this.isReadOnlyModuleProperties = false;
        } else {
            this.markLineNumber = options.markLineNumber();
            Boolean isSimple = (Boolean)options.getProperty("readOnlyModuleProperties");
            if (isSimple != null && isSimple.booleanValue()) {
                this.isReadOnlyModuleProperties = true;
                options.setSemanticCheck(false);
            } else {
                this.isReadOnlyModuleProperties = false;
            }
        }
        if (this.markLineNumber) {
            this.module.initLineNoMap();
            this.tempLineNumbers = new HashMap();
        }
        if (this.isReadOnlyModuleProperties) {
            this.module.setReadOnly();
        }
    }

    final void addUnnamedReportItem(DesignElement element) {
        assert (element instanceof ReportItem);
        if (!this.unnamedReportItems.contains(element)) {
            this.unnamedReportItems.add(element);
        }
    }

    final void addUnresolveListingElement(ListingElement element) {
        if (!this.unresolvedListingElements.contains(element)) {
            this.unresolvedListingElements.add(element);
        }
    }

    final void addExtendedItem(ExtendedItem element) {
        this.extendedItemList.add(element);
    }

    public boolean isReadOnlyModuleProperties() {
        return this.isReadOnlyModuleProperties;
    }

    private void handleStyleNameCompatibilities() {
        if (this.module instanceof ReportDesign) {
            String name;
            List<DesignElement> designStyles = this.module.getSlot(0).getContents();
            if (designStyles == null || designStyles.isEmpty()) {
                return;
            }
            HashMap<String, DesignElement> styleMap = new HashMap<String, DesignElement>();
            Theme theme = this.module.getTheme();
            if (theme != null) {
                List<DesignElement> themeStyles = theme.getSlot(0).getContents();
                if (themeStyles != null) {
                    int i = 0;
                    while (i < themeStyles.size()) {
                        DesignElement style = themeStyles.get(i);
                        name = style.getName().toLowerCase();
                        if (!styleMap.containsKey(name)) {
                            styleMap.put(name, style);
                        }
                        ++i;
                    }
                }
                List<CssStyle> csses = CssNameManager.getStyles(theme);
                int i = 0;
                while (csses != null && i < csses.size()) {
                    CssStyle s = csses.get(i);
                    String name2 = s.getName().toLowerCase();
                    if (!styleMap.containsKey(name2)) {
                        styleMap.put(name2, s);
                    }
                    ++i;
                }
            }
            List<CssStyle> csses = CssNameManager.getStyles((ICssStyleSheetOperation)((Object)this.module));
            int i = 0;
            while (csses != null && i < csses.size()) {
                CssStyle s = csses.get(i);
                name = s.getName().toLowerCase();
                if (!styleMap.containsKey(name)) {
                    styleMap.put(name, s);
                }
                ++i;
            }
            if (!styleMap.isEmpty()) {
                i = 0;
                while (i < designStyles.size()) {
                    DesignElement designStyle = designStyles.get(i);
                    String styleName = designStyle.getName();
                    String lowerCaseName = styleName.toLowerCase();
                    NameSpace ns = new NameExecutor(designStyle).getNameHelper(this.module).getNameSpace(0);
                    if (styleMap.containsKey(lowerCaseName)) {
                        DesignElement existedStyle = (DesignElement)styleMap.get(lowerCaseName);
                        assert (existedStyle != null);
                        if (!existedStyle.getName().equals(styleName)) {
                            int index = 0;
                            String baseName = styleName;
                            while (styleMap.containsKey(lowerCaseName) || ns.contains(lowerCaseName)) {
                                styleName = String.valueOf(baseName) + ++index;
                                lowerCaseName = styleName.toLowerCase();
                            }
                            ns.remove(designStyle);
                            if (this.styledElements != null) {
                                int j = 0;
                                while (j < this.styledElements.size()) {
                                    StyledElement styledElement = (StyledElement)this.styledElements.get(j);
                                    if (designStyle.getName().equals(styledElement.getStyleName())) {
                                        styledElement.setStyleName(styleName.trim());
                                    }
                                    ++j;
                                }
                            }
                            designStyle.setName(styleName.trim());
                            ns.insert(designStyle);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    static class ModuleLexicalHandler
    implements LexicalHandler {
        ModuleParserHandler handler = null;

        ModuleLexicalHandler(ModuleParserHandler handler) {
            this.handler = handler;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        public void endCDATA() throws SAXException {
            AbstractParseState tmpState = this.handler.topState;
            tmpState.setIsCDataSection(true);
        }

        public void endDTD() throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }
    }
}

