/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.simpleapi.IHideRule;
import org.eclipse.birt.report.model.api.simpleapi.IHighlightRule;
import org.eclipse.birt.report.model.api.simpleapi.IRow;
import org.eclipse.birt.report.model.simpleapi.DesignElement;
import org.eclipse.birt.report.model.simpleapi.HideRuleMethodUtil;
import org.eclipse.birt.report.model.simpleapi.HighlightRuleMethodUtil;

public class Row
extends DesignElement
implements IRow {
    public Row(RowHandle handle) {
        super(handle);
    }

    public String getHeight() {
        DimensionHandle height = ((RowHandle)this.handle).getHeight();
        return height == null ? null : height.getStringValue();
    }

    public String getBookmark() {
        return ((RowHandle)this.handle).getBookmark();
    }

    public void setBookmark(String value) throws SemanticException {
        this.setProperty("bookmark", value);
    }

    public void addHighlightRule(IHighlightRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HighlightRuleMethodUtil.addHighlightRule(this.handle, rule);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public IHighlightRule[] getHighlightRules() {
        return HighlightRuleMethodUtil.getHighlightRules(this.handle);
    }

    public void removeHighlightRules() throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HighlightRuleMethodUtil.removeHighlightRules(this.handle);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void removeHighlightRule(IHighlightRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HighlightRuleMethodUtil.removeHighlightRule(this.handle, rule);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void addHideRule(IHideRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HideRuleMethodUtil.addHideRule(this.handle, rule);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public IHideRule[] getHideRules() {
        return HideRuleMethodUtil.getHideRules(this.handle);
    }

    public void removeHideRule(IHideRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HideRuleMethodUtil.removeHideRule(this.handle, rule);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void removeHideRules() throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            HideRuleMethodUtil.removeHideRules(this.handle);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }
}

