/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.jaxrs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.platform.reporting.api.ReportInstance;
import org.nuxeo.ecm.platform.reporting.report.ReportParameter;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="report")
public class ReportResource
extends DefaultObject {
    protected static final String USER_PARAMS_NAME = "birtUserParams";
    protected ReportInstance report;

    protected void initialize(Object ... args) {
        this.report = (ReportInstance)args[0];
    }

    @GET
    @Produces(value={"text/html"})
    public String doGet() throws Exception {
        return this.report.getModel().getReportName();
    }

    protected String getReportKey() {
        return this.report.getDoc().getId() + "-" + this.getContext().getUserSession().getPrincipal().getName();
    }

    protected String buildTmpPath(String key) {
        String dirPath = new Path(System.getProperty("java.io.tmpdir")).append("birt-" + key).toString();
        File baseDir = new File(dirPath);
        if (baseDir.exists()) {
            return dirPath;
        }
        baseDir.mkdir();
        File imagesDir = new File(dirPath + "/images");
        imagesDir.mkdir();
        return dirPath;
    }

    @GET
    @javax.ws.rs.Path(value="images/{key}/{name}")
    public Object getImage(@PathParam(value="key") String key, @PathParam(value="name") String name) throws Exception {
        String tmpPath = this.buildTmpPath(key);
        File imageFile = new File(tmpPath + "/images/" + name);
        return Response.ok((Object)new FileInputStream(imageFile)).build();
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="editParams")
    public Object editParams(@QueryParam(value="target") String target, @QueryParam(value="errors") String errors) throws Exception {
        HttpSession session = WebEngine.getActiveContext().getRequest().getSession();
        Map userParams = (Map)session.getAttribute(USER_PARAMS_NAME);
        List params = this.report.getReportUserParameters();
        this.fillReportParameters(params, userParams);
        this.markReportParametersInError(params, errors);
        return this.getView("editParams").arg("params", (Object)params).arg("target", (Object)target);
    }

    protected void fillReportParameters(List<ReportParameter> reportParameters, Map<String, Object> userParams) {
        if (userParams != null) {
            for (ReportParameter p : reportParameters) {
                if (!userParams.containsKey(p.getName())) continue;
                p.setObjectValue(userParams.get(p.getName()));
            }
        }
    }

    protected void markReportParametersInError(List<ReportParameter> reportParameters, String errors) {
        if (errors != null) {
            String[] errs;
            block0: for (String err : errs = errors.split(",")) {
                if (err.isEmpty()) continue;
                for (ReportParameter p : reportParameters) {
                    if (!p.getName().equals(err)) continue;
                    p.setObjectValue(null);
                    p.setError(true);
                    continue block0;
                }
            }
        }
    }

    protected void readParams(Map<String, Object> userParams, List<String> paramsInError) throws Exception {
        FormData data;
        List params = this.report.getReportUserParameters();
        if (params.size() > 0 && (data = this.getContext().getForm()) != null) {
            for (ReportParameter param : params) {
                String name = param.getName();
                if (data.getString(name) != null) {
                    String strValue = data.getString(name);
                    if (param.setAndValidateValue(strValue)) {
                        Object value = param.getObjectValue();
                        userParams.put(name, value);
                        continue;
                    }
                    paramsInError.add(name);
                    continue;
                }
                if (userParams.containsKey(name)) continue;
                paramsInError.add(name);
            }
        }
    }

    @POST
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="html")
    public Object editAndRenderHtml() throws Exception {
        return this.html(false);
    }

    protected Object validateInput(Map<String, Object> userParams, String target) throws Exception {
        HttpSession session = WebEngine.getActiveContext().getRequest().getSession();
        Map savedUserParams = (Map)session.getAttribute(USER_PARAMS_NAME);
        if (savedUserParams != null) {
            userParams.putAll(savedUserParams);
        }
        ArrayList<String> errors = new ArrayList<String>();
        this.readParams(userParams, errors);
        this.saveUserParameters(userParams);
        if (!errors.isEmpty()) {
            String errorList = "";
            for (String err : errors) {
                errorList = errorList + err + ",";
            }
            errorList = URLEncoder.encode(errorList, "UTF-8");
            return this.redirect(this.getPath() + "/editParams?target=" + target + "&errors=" + errorList);
        }
        return null;
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="html")
    public Object html(@QueryParam(value="forceFormDisplay") boolean forceFormDisplay) throws Exception {
        HashMap<String, Object> userParams = new HashMap<String, Object>();
        Object validationError = this.validateInput(userParams, "html");
        if (validationError != null) {
            return validationError;
        }
        if (forceFormDisplay) {
            return this.redirect(this.getPath() + "/editParams?target=html");
        }
        String key = this.getReportKey();
        String tmpPath = this.buildTmpPath(key);
        File reportFile = new File(tmpPath + "/report");
        FileOutputStream out = new FileOutputStream(reportFile);
        HTMLRenderOption options = new HTMLRenderOption();
        options.setImageHandler((IHTMLImageHandler)new HTMLServerImageHandler());
        options.setOutputFormat("html");
        options.setOutputStream((OutputStream)out);
        options.setBaseImageURL("images/" + key);
        options.setImageDirectory(tmpPath + "/images");
        this.report.render((IRenderOption)options, userParams);
        return Response.ok((Object)new FileInputStream(reportFile), (String)"text/html").build();
    }

    protected void saveUserParameters(Map<String, Object> userParams) {
        HttpSession session = WebEngine.getActiveContext().getRequest().getSession();
        session.setAttribute(USER_PARAMS_NAME, userParams);
    }

    @POST
    @Produces(value={"application/pdf"})
    @javax.ws.rs.Path(value="pdf")
    public Object editAndRenderPdf() throws Exception {
        return this.pdf(false);
    }

    @GET
    @Produces(value={"application/pdf"})
    @javax.ws.rs.Path(value="pdf")
    public Object pdf(@QueryParam(value="forceFormDisplay") boolean forceDisplayForm) throws Exception {
        HashMap<String, Object> userParams = new HashMap<String, Object>();
        Object validationError = this.validateInput(userParams, "pdf");
        if (validationError != null) {
            return validationError;
        }
        if (forceDisplayForm) {
            return this.redirect(this.getPath() + "/editParams?target=pdf");
        }
        String key = this.getReportKey();
        String tmpPath = this.buildTmpPath(key);
        File reportFile = new File(tmpPath + "/report");
        FileOutputStream out = new FileOutputStream(reportFile);
        PDFRenderOption options = new PDFRenderOption();
        options.setImageHandler((IHTMLImageHandler)new HTMLServerImageHandler());
        options.setOutputFormat("pdf");
        options.setOutputStream((OutputStream)out);
        this.report.render((IRenderOption)options, userParams);
        return Response.ok((Object)new FileInputStream(reportFile), (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment;filename=" + key + ".pdf")).build();
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="clearParams")
    public Object clearParams(@QueryParam(value="target") String target) throws Exception {
        HttpSession session = WebEngine.getActiveContext().getRequest().getSession();
        session.removeAttribute(USER_PARAMS_NAME);
        return this.redirect(this.getPath() + "/editParams?target=" + target);
    }
}

