/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.seam;

import com.sun.faces.util.MessageFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.reporting.api.ReportModel;
import org.nuxeo.ecm.platform.reporting.api.ReportService;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileChoice;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="reportActions")
@Scope(value=ScopeType.PAGE)
@Install(precedence=10)
public class ReportActions
implements Serializable {
    private static final long serialVersionUID = -1155863420157051403L;
    protected static final Log log = LogFactory.getLog(ReportActions.class);
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected transient UserManager userManager;
    protected String reportsContainerPath = null;
    protected DocumentModel newReportModel = null;
    protected boolean showForm = false;

    @Factory(value="reportModels", scope=ScopeType.EVENT, autoCreate=true)
    public List<ReportModel> getAvailableModels() {
        try {
            ReportService rs = (ReportService)Framework.getLocalService(ReportService.class);
            return rs.getReportAvailableModels(this.documentManager);
        }
        catch (ClientException e) {
            log.error((Object)"Error while getting reports models", (Throwable)e);
            return new ArrayList<ReportModel>();
        }
    }

    public ReportModel getReportModel(String docId) {
        try {
            DocumentModel reportModelDoc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
            return (ReportModel)reportModelDoc.getAdapter(ReportModel.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DocumentModel getBareReportModel() throws ClientException {
        return this.documentManager.createDocumentModel("BirtReportModel");
    }

    public DocumentModel getNewReportModel() throws ClientException {
        if (this.newReportModel == null) {
            this.newReportModel = this.getBareReportModel();
        }
        return this.newReportModel;
    }

    public String saveDocument() throws ClientException {
        this.createReportsModelContainerIfNeeded();
        String view = this.documentActions.saveDocument(this.newReportModel);
        this.resetDocument();
        this.toggleForm();
        return view;
    }

    protected void createReportsModelContainerIfNeeded() throws ClientException {
        String path = this.getReportModelsContainerPath();
        if (!this.documentManager.exists((DocumentRef)new PathRef(path))) {
            this.createReportsModelContainer(path);
        }
    }

    protected void createReportsModelContainer(String path) throws ClientException {
        new UnrestrictedReportModelsContainerCreator(this.documentManager, path).runUnrestricted();
    }

    protected void resetDocument() {
        this.newReportModel = null;
    }

    public String getReportModelsContainerPath() throws ClientException {
        if (this.reportsContainerPath == null) {
            try {
                ReportService reportService = (ReportService)Framework.getService(ReportService.class);
                this.reportsContainerPath = reportService.getReportModelsContainer();
            }
            catch (Exception e) {
                log.error((Object)"Unable to retrieve ReportService", (Throwable)e);
            }
        }
        return this.reportsContainerPath;
    }

    public boolean isShowForm() {
        return this.showForm;
    }

    public void toggleForm() {
        this.showForm = !this.showForm;
    }

    public void toggleAndReset() {
        this.toggleForm();
        this.resetDocument();
    }

    public void validateReportExtension(FacesContext context, UIComponent component, Object value) {
        if (value instanceof InputFileInfo) {
            InputFileInfo info = (InputFileInfo)value;
            InputFileChoice choice = info.getConvertedChoice();
            if (InputFileChoice.tempKeep != choice && InputFileChoice.upload != choice) {
                return;
            }
            String filename = info.getConvertedFilename();
            if (filename != null && !filename.endsWith(".rptdesign")) {
                throw new ValidatorException(MessageFactory.getMessage((FacesContext)context, (String)"error.inputFile.authorizedExtensions", (Object[])new Object[]{".rptdesign"}));
            }
        }
    }

    public class UnrestrictedReportModelsContainerCreator
    extends UnrestrictedSessionRunner {
        protected String reportModelsContainerPath;

        protected UnrestrictedReportModelsContainerCreator(CoreSession session, String reportModelsContainerPath) {
            super(session);
            this.reportModelsContainerPath = reportModelsContainerPath;
        }

        public void run() throws ClientException {
            if (!this.session.exists((DocumentRef)new PathRef(this.reportModelsContainerPath))) {
                DocumentModel doc = this.session.createDocumentModel(this.session.getRootDocument().getPathAsString(), this.reportModelsContainerPath.substring(1), "BirtReportModelsRoot");
                doc.setPropertyValue("dc:title", (Serializable)((Object)"Report Models"));
                doc = this.session.createDocument(doc);
                ACPImpl acp = new ACPImpl();
                ACLImpl acl = new ACLImpl();
                for (String administratorGroup : ReportActions.this.userManager.getAdministratorsGroups()) {
                    ACE ace = new ACE(administratorGroup, "Everything", true);
                    acl.add((Object)ace);
                }
                acp.addACL((ACL)acl);
                doc.setACP((ACP)acp, true);
                this.session.save();
            }
        }
    }
}

