/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.api;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.api.IParameterDefn;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.reporting.api.BaseBirtReportAdapter;
import org.nuxeo.ecm.platform.reporting.api.ReportModel;
import org.nuxeo.ecm.platform.reporting.report.ReportHelper;
import org.nuxeo.ecm.platform.reporting.report.ReportParameter;

public class BirtReportModel
extends BaseBirtReportAdapter
implements ReportModel {
    protected static final String PREFIX = "birtmodel";
    protected transient List<IParameterDefn> cachedParamsDef = null;

    public BirtReportModel(DocumentModel doc) {
        super(doc);
    }

    @Override
    public String getId() {
        return this.doc.getId();
    }

    @Override
    public String getReportName() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue("birtmodel:reportName"));
    }

    @Override
    public InputStream getReportFileAsStream() throws Exception {
        BlobHolder bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
        return bh.getBlob().getStream();
    }

    @Override
    public void parseParametersDefinition() throws Exception {
        List<IParameterDefn> paramsDef = this.getParameterDef();
        for (IParameterDefn def : paramsDef) {
            ReportParameter param = new ReportParameter(def);
            this.setParameter(param, false);
        }
    }

    @Override
    public void updateMetadata() throws Exception {
        Map<String, String> meta = ReportHelper.getReportMetaData(this.getReportFileAsStream());
        String name = meta.get("displayName");
        if (name == null) {
            BlobHolder bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
            name = bh.getBlob().getFilename();
        }
        this.doc.setPropertyValue("birtmodel:reportName", (Serializable)((Object)name));
        if (meta.get("title") != null) {
            this.doc.setPropertyValue("dc:title", (Serializable)((Object)meta.get("title")));
        }
        if (meta.get("description") != null) {
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)meta.get("description")));
        }
    }

    protected List<IParameterDefn> getParameterDef() throws Exception {
        if (this.cachedParamsDef == null) {
            IReportRunnable report = ReportHelper.getReport(this.getReportFileAsStream());
            this.cachedParamsDef = ReportHelper.getReportParameter(report);
        }
        return this.cachedParamsDef;
    }

    @Override
    public List<ReportParameter> getReportParameters() throws Exception {
        Map<String, String> storedParams = this.getStoredParameters();
        List<IParameterDefn> paramsDef = this.getParameterDef();
        ArrayList<ReportParameter> result = new ArrayList<ReportParameter>();
        for (IParameterDefn def : paramsDef) {
            ReportParameter param = new ReportParameter(def, storedParams.get(def.getName()));
            result.add(param);
        }
        return result;
    }

    @Override
    public Map<String, String> getStoredParameters() throws ClientException {
        List localParams = (List)((Object)this.doc.getPropertyValue("birtmodel:parameters"));
        HashMap<String, String> params = new HashMap<String, String>();
        if (localParams != null) {
            for (Map localParam : localParams) {
                String name = (String)localParam.get("pName");
                String value = (String)localParam.get("pValue");
                if (value == null) continue;
                params.put(name, value);
            }
        }
        return params;
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }
}

