/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.reporting.api.ReportInstance;
import org.nuxeo.ecm.platform.reporting.api.ReportModel;
import org.nuxeo.ecm.platform.reporting.api.ReportService;
import org.nuxeo.ecm.platform.reporting.engine.BirtEngine;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ReportComponent
extends DefaultComponent
implements ReportService {
    protected static final Log log = LogFactory.getLog(ReportComponent.class);
    public static final String BIRT_REPORTS_CONTAINER_PATH = "/report-models";

    public void activate(ComponentContext context) throws Exception {
    }

    public void deactivate(ComponentContext context) throws Exception {
        BirtEngine.destroyBirtEngine();
    }

    @Override
    public List<ReportInstance> getReportInstanceByModelName(CoreSession session, String reportModelName) throws ClientException {
        String uuid = this.getReportModelByName(session, reportModelName).getId();
        String query = "SELECT * FROM BirtReport WHERE birt:modelRef='" + uuid + "'";
        DocumentModelList reports = session.query(query);
        ArrayList<ReportInstance> result = new ArrayList<ReportInstance>();
        for (DocumentModel doc : reports) {
            ReportInstance report = (ReportInstance)doc.getAdapter(ReportInstance.class);
            if (report == null) continue;
            result.add(report);
        }
        return result;
    }

    @Override
    public ReportInstance getReportInstanceByKey(CoreSession session, String key) throws ClientException {
        String query = "SELECT * FROM BirtReport WHERE birt:reportKey='" + key + "'";
        DocumentModelList reports = session.query(query);
        if (reports.isEmpty()) {
            return null;
        }
        return (ReportInstance)((DocumentModel)reports.get(0)).getAdapter(ReportInstance.class);
    }

    @Override
    public String getReportModelsContainer() {
        return BIRT_REPORTS_CONTAINER_PATH;
    }

    @Override
    public ReportModel getReportModelByName(CoreSession session, String reportModelName) throws ClientException {
        String query = "SELECT * FROM BirtReportModel WHERE birtmodel:reportName='" + reportModelName + "'";
        DocumentModelList reports = session.query(query);
        if (reports.isEmpty()) {
            return null;
        }
        return (ReportModel)((DocumentModel)reports.get(0)).getAdapter(ReportModel.class);
    }

    @Override
    public List<ReportModel> getReportAvailableModels(CoreSession session) throws ClientException {
        String query = "SELECT * FROM BirtReportModel WHERE ecm:currentLifeCycleState != 'deleted'";
        DocumentModelList reports = session.query(query);
        ArrayList<ReportModel> result = new ArrayList<ReportModel>();
        for (DocumentModel doc : reports) {
            ReportModel report = (ReportModel)doc.getAdapter(ReportModel.class);
            if (report == null) continue;
            result.add(report);
        }
        return result;
    }
}

