/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.reporting.api.ReportInstance;
import org.nuxeo.ecm.platform.reporting.api.ReportModel;

public class ReportParserListener
implements EventListener {
    protected static final Log log = LogFactory.getLog(ReportParserListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            ReportInstance reportInstance;
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc.hasSchema("birtreportmodel")) {
                ReportModel reportModel = (ReportModel)doc.getAdapter(ReportModel.class);
                if (reportModel != null) {
                    try {
                        if (doc.getProperty("file:content").isDirty()) {
                            reportModel.parseParametersDefinition();
                            reportModel.updateMetadata();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while parsing report model parameters", (Throwable)e);
                    }
                }
            } else if (doc.hasSchema("birtreport") && (reportInstance = (ReportInstance)doc.getAdapter(ReportInstance.class)) != null) {
                try {
                    reportInstance.initParameterList();
                }
                catch (Exception e) {
                    log.error((Object)"Error initializing report parameters", (Throwable)e);
                }
            }
        }
    }
}

