/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.reporting.report.ReportParameter;

public abstract class BaseBirtReportAdapter {
    protected DocumentModel doc;

    public BaseBirtReportAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    protected CoreSession getSession() {
        return this.doc.getCoreSession();
    }

    protected abstract String getPrefix();

    public abstract List<ReportParameter> getReportParameters() throws IOException;

    public void setParameter(ReportParameter param) throws IOException {
        this.setParameter(param, true);
    }

    public void setParameter(ReportParameter param, boolean save) throws IOException {
        this.setParameter(param.getName(), param.getStringValue(), save);
    }

    public void setParameter(String name, Object value) throws IOException {
        this.setParameter(name, value, true);
    }

    public void setParameter(String name, Object value, boolean save) throws IOException {
        List<ReportParameter> reportParams = this.getReportParameters();
        ReportParameter targetParameter = null;
        for (ReportParameter reportParam : reportParams) {
            if (!reportParam.getName().equals(name)) continue;
            targetParameter = reportParam;
            break;
        }
        if (targetParameter == null) {
            return;
        }
        targetParameter.setObjectValue(value);
        String stringValue = targetParameter.getStringValue();
        ArrayList localParams = (ArrayList)this.doc.getPropertyValue(this.getPrefix() + ":parameters");
        if (localParams == null) {
            localParams = new ArrayList();
        }
        boolean addParam = true;
        for (Map map : localParams) {
            String pName = (String)map.get("pName");
            if (!name.equals(pName)) continue;
            map.put("pValue", stringValue);
            addParam = false;
            break;
        }
        if (addParam) {
            HashMap<String, String> newEntry = new HashMap<String, String>();
            newEntry.put("pName", name);
            newEntry.put("pValue", stringValue);
            localParams.add(newEntry);
        }
        this.doc.setPropertyValue(this.getPrefix() + ":parameters", (Serializable)localParams);
        if (save) {
            this.doc = this.getSession().saveDocument(this.doc);
        }
    }

    public DocumentModel getDoc() {
        return this.doc;
    }
}

