/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.reporting.api.BaseBirtReportAdapter;
import org.nuxeo.ecm.platform.reporting.api.ReportInstance;
import org.nuxeo.ecm.platform.reporting.api.ReportModel;
import org.nuxeo.ecm.platform.reporting.engine.BirtEngine;
import org.nuxeo.ecm.platform.reporting.report.ReportContext;
import org.nuxeo.ecm.platform.reporting.report.ReportHelper;
import org.nuxeo.ecm.platform.reporting.report.ReportParameter;

public class BirtReportInstance
extends BaseBirtReportAdapter
implements ReportInstance {
    protected static final String PREFIX = "birt";

    public BirtReportInstance(DocumentModel doc) {
        super(doc);
    }

    @Override
    public ReportModel getModel() {
        String modelUUID = (String)((Object)this.doc.getPropertyValue("birt:modelRef"));
        final IdRef modelRef = new IdRef(modelUUID);
        final DocumentModel[] docs = new DocumentModel[1];
        new UnrestrictedSessionRunner(this.getSession()){

            public void run() {
                DocumentModel doc = this.session.getDocument((DocumentRef)modelRef);
                doc.detach(true);
                docs[0] = doc;
            }
        }.runUnrestricted();
        return (ReportModel)docs[0].getAdapter(ReportModel.class);
    }

    @Override
    public Map<String, String> getStoredParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        List localParams = (List)((Object)this.doc.getPropertyValue("birt:parameters"));
        if (localParams != null) {
            for (Map localParam : localParams) {
                String name = (String)localParam.get("pName");
                String value = (String)localParam.get("pValue");
                if (value == null) continue;
                params.put(name, value);
            }
        }
        return params;
    }

    @Override
    public List<ReportParameter> getReportParameters() throws IOException {
        List<ReportParameter> params = this.getModel().getReportParameters();
        Map<String, String> modelParams = this.getModel().getStoredParameters();
        Map<String, String> localParams = this.getStoredParameters();
        for (ReportParameter param : params) {
            String value = modelParams.get(param.getName());
            if (value != null && !value.isEmpty()) {
                param.setValue(value);
                param.setEditable(false);
            }
            if ((value = localParams.get(param.getName())) == null || value.isEmpty()) continue;
            param.setValue(value);
        }
        return params;
    }

    @Override
    public List<ReportParameter> getReportUserParameters() throws IOException {
        List<ReportParameter> params = this.getReportParameters();
        ReportContext.setContextualParameters(params, this.doc);
        ArrayList<ReportParameter> userParams = new ArrayList<ReportParameter>();
        for (ReportParameter param : params) {
            if (param.getStringValue() != null && !param.getStringValue().isEmpty()) continue;
            userParams.add(param);
        }
        return userParams;
    }

    @Override
    public void initParameterList() throws IOException {
        String oldModelRef = (String)((Object)this.doc.getPropertyValue("birt:oldModelRef"));
        String modelRef = (String)((Object)this.doc.getPropertyValue("birt:modelRef"));
        if (oldModelRef == null || oldModelRef.isEmpty() || !oldModelRef.equals(modelRef)) {
            this.doc.setPropertyValue("birt:oldModelRef", (Serializable)((Object)modelRef));
            List<ReportParameter> params = this.getModel().getReportParameters();
            ArrayList localParams = new ArrayList();
            this.doc.setPropertyValue(this.getPrefix() + ":parameters", (Serializable)localParams);
            for (ReportParameter param : params) {
                this.setParameter(param.getName(), null, false);
            }
        }
    }

    @Override
    public void render(IRenderOption options, Map<String, Object> userParameters) throws IOException {
        List<ReportParameter> params = this.getReportParameters();
        for (ReportParameter param : params) {
            if (!userParameters.containsKey(param.getName())) continue;
            param.setObjectValue(userParameters.get(param.getName()));
        }
        ReportContext.setContextualParameters(params, this.doc);
        InputStream report = this.getModel().getReportFileAsStream();
        IReportRunnable nuxeoReport = ReportHelper.getNuxeoReport(report, this.doc.getRepositoryName());
        IRunAndRenderTask task = BirtEngine.getBirtEngine().createRunAndRenderTask(nuxeoReport);
        Map<String, Object> birtParams = this.computeParametersForBirt(params);
        task.setParameterValues(birtParams);
        task.setRenderOption(options);
        try {
            task.run();
        }
        catch (BirtException e) {
            throw new NuxeoException((Throwable)e);
        }
        task.close();
    }

    protected Map<String, Object> computeParametersForBirt(List<ReportParameter> parameters) {
        HashMap<String, Object> birtParameters = new HashMap<String, Object>();
        for (ReportParameter param : parameters) {
            Object value = param.getObjectValue();
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                value = new Date(date.getTime());
            }
            birtParameters.put(param.getName(), value);
        }
        return birtParameters;
    }

    @Override
    public String getReportKey() {
        try {
            return (String)((Object)this.doc.getPropertyValue("birt:reportKey"));
        }
        catch (PropertyException e) {
            return null;
        }
    }

    @Override
    public void setReportKey(String key) {
        this.doc.setPropertyValue("birt:reportKey", (Serializable)((Object)key));
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }
}

