/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.datasource;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.platform.reporting.datasource.NuxeoDSConfig;
import org.nuxeo.runtime.api.Framework;

public class DSHelper {
    protected static Map<String, NuxeoDSConfig> detectedDS;

    public static Map<String, NuxeoDSConfig> getDSForRepos() {
        if (detectedDS == null) {
            HashMap<String, NuxeoDSConfig> configs = new HashMap<String, NuxeoDSConfig>();
            String singleDS = Framework.getProperty((String)"nuxeo.db.singleDataSource", null);
            if (singleDS == null || singleDS.isEmpty()) {
                SQLRepositoryService sqlRepositoryService = (SQLRepositoryService)Framework.getService(SQLRepositoryService.class);
                for (String repositoryName : sqlRepositoryService.getRepositoryNames()) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    String xaDataSourceName = sqlRepositoryService.getRepositoryDataSourceAndProperties(repositoryName, properties);
                    NuxeoDSConfig config = new NuxeoDSConfig(xaDataSourceName, properties);
                    configs.put(repositoryName, config);
                }
            }
            detectedDS = configs;
        }
        return detectedDS;
    }

    public static NuxeoDSConfig getDefaultRepoDS(String repositoryName) {
        Map<String, NuxeoDSConfig> configs = DSHelper.getDSForRepos();
        if (configs.size() == 0) {
            return null;
        }
        if (configs.size() == 1) {
            return configs.get(configs.keySet().iterator().next());
        }
        if (repositoryName == null) {
            repositoryName = "default";
        }
        return configs.get(repositoryName);
    }

    public static NuxeoDSConfig getReplacementDS(String birtDSName, String repositoryName) {
        String name = birtDSName.toLowerCase();
        if (name.equals("nuxeo") || name.equals("nuxeovcs")) {
            return DSHelper.getDefaultRepoDS(repositoryName);
        }
        if (name.startsWith("nuxeo-")) {
            name = name.replace("nuxeo-", "");
        }
        Map<String, NuxeoDSConfig> configs = DSHelper.getDSForRepos();
        return configs.get(name);
    }
}

