/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.datasource;

import java.util.Map;
import org.nuxeo.ecm.platform.reporting.datasource.SupportedDBHelper;
import org.nuxeo.runtime.api.Framework;

public class NuxeoDSConfig {
    protected String driverClass;
    protected String url;
    protected String userName;
    protected String password;
    public static final String H2_PREFIX = "org.h2";
    public static final String PG_PREFIX = "org.postgresql";
    public static final String MSSQL_PREFIX = "net.sourceforge.jtds";
    public static final String MYSQL_PREFIX = "com.mysql.jdbc";
    public static final String ORACLE_PREFIX = "oracle.jdbc";

    public NuxeoDSConfig(String dataSourceName, Map<String, String> properties) {
        if (dataSourceName.startsWith(H2_PREFIX)) {
            this.initForH2(properties);
        } else if (dataSourceName.startsWith(PG_PREFIX)) {
            this.initForPostgreSQL(properties);
        } else if (dataSourceName.startsWith(MSSQL_PREFIX)) {
            this.initForMSSQL(properties);
        } else if (dataSourceName.startsWith(MYSQL_PREFIX)) {
            this.initForMySQL(properties);
        } else if (dataSourceName.startsWith(ORACLE_PREFIX)) {
            this.initForOracle(properties);
        }
    }

    protected void initForH2(Map<String, String> properties) {
        this.userName = this.getProp(properties, "User");
        this.password = this.getProp(properties, "Password");
        this.url = this.getProp(properties, "URL");
        this.driverClass = SupportedDBHelper.getDriver("h2");
    }

    protected String getIntegerProp(Map<String, String> properties, String name) {
        String value = this.getProp(properties, name);
        if (value != null) {
            return value;
        }
        return this.getProp(properties, name + "/Integer");
    }

    protected void initForPostgreSQL(Map<String, String> properties) {
        this.userName = this.getProp(properties, "User");
        this.password = this.getProp(properties, "Password");
        this.url = this.getProp(properties, "URL");
        if (this.url == null) {
            this.url = "jdbc:postgresql://" + this.getProp(properties, "ServerName") + ":" + this.getIntegerProp(properties, "PortNumber") + "/" + this.getProp(properties, "DatabaseName");
        }
        this.driverClass = this.getProp(properties, "Driver");
        if (this.driverClass == null) {
            this.driverClass = SupportedDBHelper.getDriver("postgresql");
        }
    }

    protected void initForMSSQL(Map<String, String> properties) {
        this.userName = this.getProp(properties, "User");
        this.password = this.getProp(properties, "Password");
        this.url = this.getProp(properties, "URL");
        if (this.url == null) {
            this.url = "jdbc:jtds:sqlserver://" + this.getProp(properties, "ServerName") + ":" + this.getIntegerProp(properties, "PortNumber") + "/" + this.getProp(properties, "DatabaseName") + ";useCursors=true";
        }
        this.driverClass = this.getProp(properties, "Driver");
        if (this.driverClass == null) {
            this.driverClass = SupportedDBHelper.getDriver("mssql");
        }
    }

    protected void initForMySQL(Map<String, String> properties) {
        this.userName = this.getProp(properties, "User");
        this.password = this.getProp(properties, "Password");
        this.url = this.getProp(properties, "URL");
        this.driverClass = this.getProp(properties, "Driver");
        if (this.driverClass == null) {
            this.driverClass = SupportedDBHelper.getDriver("mysql");
        }
    }

    protected void initForOracle(Map<String, String> properties) {
        this.userName = this.getProp(properties, "User");
        this.password = this.getProp(properties, "Password");
        this.url = this.getProp(properties, "URL");
        this.driverClass = this.getProp(properties, "Driver");
        if (this.driverClass == null) {
            this.driverClass = SupportedDBHelper.getDriver("oracle");
        }
    }

    protected String getProp(Map<String, String> properties, String name) {
        String value = properties.get(name);
        if (value == null) {
            return null;
        }
        return Framework.expandVars((String)value);
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("username:");
        sb.append(this.userName);
        sb.append("\npassword:");
        sb.append(this.password);
        sb.append("\ndriver:");
        sb.append(this.driverClass);
        sb.append("\nurl:");
        sb.append(this.url);
        return sb.toString();
    }
}

