/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.datasource;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SupportedDBHelper {
    protected static Map<String, String> driverMapping;
    public static final String H2 = "h2";
    public static final String PGSQL = "postgresql";
    public static final String MSSQL = "mssql";
    public static final String MYSQL = "mysql";
    public static final String ORACLE = "oracle";

    public static Map<String, String> getMapping() {
        if (driverMapping == null) {
            driverMapping = new HashMap<String, String>();
            driverMapping.put(H2, "org.h2.Driver");
            driverMapping.put(PGSQL, "org.postgresql.Driver");
            driverMapping.put(MSSQL, "net.sourceforge.jtds.jdbc.Driver");
            driverMapping.put(MYSQL, "com.mysql.jdbc.Driver");
            driverMapping.put(ORACLE, "oracle.jdbc.OracleDriver");
        }
        return driverMapping;
    }

    public static String getDriver(String name) {
        return SupportedDBHelper.getMapping().get(name);
    }

    public static URL getDriverJar(String name) throws MalformedURLException {
        String javaName = SupportedDBHelper.getDriver(name);
        String classPath = javaName.replace(".", "/");
        classPath = classPath + ".class";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(classPath);
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        String file = url.getFile();
        if ("vfszip".equals(protocol)) {
            return new URL("vfszip:" + file.substring(0, file.length() - classPath.length() - 1));
        }
        if ("jar".equals(protocol)) {
            return new URL(file.substring(0, file.length() - classPath.length() - 2));
        }
        throw new Error("Cannot loate jar location of '" + name + "' JDBC Driver, unsupported protocol '" + protocol + "'");
    }

    public static List<URL> getDriverJars() throws MalformedURLException {
        ArrayList<URL> jars = new ArrayList<URL>();
        for (String name : SupportedDBHelper.getMapping().keySet()) {
            URL jar = SupportedDBHelper.getDriverJar(name);
            if (jar == null) continue;
            jars.add(jar);
        }
        return jars;
    }
}

