/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IDesignEngineFactory;

public class BirtEngine {
    private static Log log = LogFactory.getLog(BirtEngine.class);
    private static IReportEngine birtEngine = null;
    private static IDesignEngine birtDesignEngine = null;
    private static Properties configProps = new Properties();
    private static final String configFile = "BirtConfig.properties";

    public static synchronized void initBirtConfig() {
        BirtEngine.loadEngineProps();
    }

    public static synchronized IReportEngine getBirtEngine() {
        if (birtEngine == null) {
            EngineConfig config = new EngineConfig();
            if (configProps != null) {
                String logLevel = configProps.getProperty("logLevel");
                Level level = Level.OFF;
                if ("SEVERE".equalsIgnoreCase(logLevel)) {
                    level = Level.SEVERE;
                } else if ("WARNING".equalsIgnoreCase(logLevel)) {
                    level = Level.WARNING;
                } else if ("INFO".equalsIgnoreCase(logLevel)) {
                    level = Level.INFO;
                } else if ("CONFIG".equalsIgnoreCase(logLevel)) {
                    level = Level.CONFIG;
                } else if ("FINE".equalsIgnoreCase(logLevel)) {
                    level = Level.FINE;
                } else if ("FINER".equalsIgnoreCase(logLevel)) {
                    level = Level.FINER;
                } else if ("FINEST".equalsIgnoreCase(logLevel)) {
                    level = Level.FINEST;
                } else if ("OFF".equalsIgnoreCase(logLevel)) {
                    level = Level.OFF;
                }
                config.setLogConfig(configProps.getProperty("logDirectory"), level);
            }
            config.setEngineHome("");
            try {
                Platform.startup((PlatformConfig)config);
            }
            catch (BirtException e) {
                log.error((Object)"Cannot startup birt", (Throwable)e);
            }
            IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            birtEngine = factory.createReportEngine(config);
            DesignConfig dconfig = new DesignConfig();
            IDesignEngineFactory df = (IDesignEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.model.DesignEngineFactory");
            birtDesignEngine = df.createDesignEngine(dconfig);
        }
        return birtEngine;
    }

    public static synchronized IDesignEngine getBirtDesignEngine() {
        if (birtDesignEngine == null) {
            BirtEngine.getBirtEngine();
        }
        return birtDesignEngine;
    }

    public static synchronized void destroyBirtEngine() {
        if (birtEngine == null) {
            return;
        }
        birtEngine.shutdown();
        Platform.shutdown();
        birtEngine = null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private static void loadEngineProps() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream in = null;
            in = cl.getResourceAsStream(configFile);
            if (in != null) {
                configProps.load(in);
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

