/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.jaxrs;

import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.reporting.api.ReportInstance;
import org.nuxeo.ecm.platform.reporting.api.ReportService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/reports")
@WebObject(type="reports")
public class ReportModule
extends ModuleRoot {
    protected ReportInstance findReport(String idOrKey) {
        boolean useIdResolution = true;
        try {
            UUID.fromString(idOrKey);
        }
        catch (IllegalArgumentException e) {
            useIdResolution = false;
        }
        CoreSession session = this.getContext().getCoreSession();
        if (useIdResolution) {
            IdRef ref = new IdRef(idOrKey);
            if (!session.exists((DocumentRef)ref)) {
                return null;
            }
            DocumentModel reportDoc = session.getDocument((DocumentRef)ref);
            return (ReportInstance)reportDoc.getAdapter(ReportInstance.class);
        }
        ReportService rs = (ReportService)Framework.getLocalService(ReportService.class);
        return rs.getReportInstanceByKey(session, idOrKey);
    }

    @GET
    @Path(value="list")
    @Produces(value={"text/html"})
    public Object listReports() {
        return null;
    }

    @Path(value="{reportIdOrName}")
    public Object getReport(@PathParam(value="reportIdOrName") String reportIdOrName) {
        ReportInstance report = this.findReport(reportIdOrName);
        if (report == null) {
            return Response.status((int)404).build();
        }
        return this.ctx.newObject("report", new Object[]{report});
    }
}

