/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.expression.InvalidExpression;
import org.eclipse.birt.data.engine.expression.NamedExpression;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.impl.util.DirectedGraph;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionCompilerUtil {
    public static CompiledExpression compile(String expr, ScriptContext cx) {
        ExpressionCompiler expressionCompiler = new ExpressionCompiler();
        expressionCompiler.setDataSetMode(true);
        return expressionCompiler.compile(expr, null, cx);
    }

    public static boolean hasColumnRow(String expression, ExprManager exprManager, ScriptContext cx) throws DataException {
        if (expression == null) {
            return false;
        }
        return ExpressionCompilerUtil.compile(expression, exprManager, cx);
    }

    public static List extractColumnExpression(IBaseExpression expression, String indicator) throws DataException {
        List columnList = new ArrayList();
        if (expression instanceof IScriptExpression) {
            columnList = ExpressionCompilerUtil.extractColumnExpression((IScriptExpression)expression, indicator);
        } else if (expression instanceof IConditionalExpression) {
            columnList = ExpressionCompilerUtil.extractColumnExpression((IConditionalExpression)expression, indicator);
        } else if (expression instanceof IExpressionCollection) {
            columnList = ExpressionCompilerUtil.extractColumnExpression((IExpressionCollection)expression, indicator);
        }
        return columnList;
    }

    private static List extractColumnExpression(IScriptExpression expression, String indicator) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        ExpressionCompilerUtil.populateColumnList(list, expression, indicator);
        return list;
    }

    private static List extractColumnExpression(IConditionalExpression expression, String indicator) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        list.addAll(ExpressionCompilerUtil.extractColumnExpression(expression.getExpression(), indicator));
        List valueList = ExpressionCompilerUtil.extractColumnExpression(expression.getOperand1(), indicator);
        int i = 0;
        while (i < valueList.size()) {
            if (!list.contains(valueList.get(i))) {
                list.add(valueList.get(i));
            }
            ++i;
        }
        valueList = ExpressionCompilerUtil.extractColumnExpression(expression.getOperand2(), indicator);
        i = 0;
        while (i < valueList.size()) {
            if (!list.contains(valueList.get(i))) {
                list.add(valueList.get(i));
            }
            ++i;
        }
        return list;
    }

    private static List extractColumnExpression(IExpressionCollection expression, String indicator) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        Object[] ce = expression.getExpressions().toArray();
        int i = 0;
        while (i < ce.length) {
            List valueList = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)ce[i], indicator);
            int j = 0;
            while (j < valueList.size()) {
                if (!list.contains(valueList.get(j))) {
                    list.add(valueList.get(j));
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static List extractDataSetColumnExpression(IBaseExpression expression) throws DataException {
        List columnList = new ArrayList();
        if (expression == null) {
            return columnList;
        }
        if (expression instanceof IScriptExpression) {
            columnList = ExpressionCompilerUtil.extractDataSetColumnExpression((IScriptExpression)expression);
        } else if (expression instanceof IConditionalExpression) {
            columnList = ExpressionCompilerUtil.extractDataSetColumnExpression((IConditionalExpression)expression);
        } else if (expression instanceof IExpressionCollection) {
            columnList = ExpressionCompilerUtil.extractDataSetColumnExpression((IExpressionCollection)expression);
        }
        return columnList;
    }

    public static List extractDataSetColumnExpression(IConditionalExpression expression) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        list.addAll(ExpressionCompilerUtil.extractDataSetColumnExpression(expression.getExpression()));
        List valueList = ExpressionCompilerUtil.extractDataSetColumnExpression(expression.getOperand1());
        int i = 0;
        while (i < valueList.size()) {
            if (!list.contains(valueList.get(i))) {
                list.add(valueList.get(i));
            }
            ++i;
        }
        valueList = ExpressionCompilerUtil.extractDataSetColumnExpression(expression.getOperand2());
        i = 0;
        while (i < valueList.size()) {
            if (!list.contains(valueList.get(i))) {
                list.add(valueList.get(i));
            }
            ++i;
        }
        return list;
    }

    public static List extractDataSetColumnExpression(IExpressionCollection expression) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        Object[] exprs = expression.getExpressions().toArray();
        int i = 0;
        while (i < exprs.length) {
            List valueList = ExpressionCompilerUtil.extractDataSetColumnExpression((IBaseExpression)exprs[i]);
            int j = 0;
            while (j < valueList.size()) {
                if (!list.contains(valueList.get(j))) {
                    list.add(valueList.get(j));
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static List extractDataSetColumnExpression(IScriptExpression expression) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        ExpressionCompilerUtil.populateColumnList(list, expression, "dataSetRow");
        return list;
    }

    public static boolean hasAggregationInExpr(IBaseExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof IScriptExpression) {
            String text = ((IScriptExpression)expression).getText();
            return ExpressionUtil.hasAggregation(text);
        }
        if (expression instanceof IConditionalExpression) {
            return ExpressionCompilerUtil.hasAggregationInExpr(((IConditionalExpression)expression).getExpression()) || ExpressionCompilerUtil.hasAggregationInExpr(((IConditionalExpression)expression).getOperand1()) || ExpressionCompilerUtil.hasAggregationInExpr(((IConditionalExpression)expression).getOperand2());
        }
        if (expression instanceof IExpressionCollection) {
            Object[] text = ((IExpressionCollection)expression).getExpressions().toArray();
            int i = 0;
            while (i < text.length) {
                if (ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)text[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isValidExpressionInQueryFilter(IBaseExpression expression, ScriptContext context) throws DataException {
        if (expression instanceof IScriptExpression) {
            String text = ((IScriptExpression)expression).getText();
            if (text == null || text.trim().length() == 0) {
                return true;
            }
            AggregateRegistry aggrReg = new AggregateRegistry(){

                public int register(AggregateExpression aggregationExpr) {
                    return -1;
                }
            };
            ExpressionCompiler expressionCompiler = new ExpressionCompiler();
            CompiledExpression expr = expressionCompiler.compile(text, aggrReg, context);
            return ExpressionCompilerUtil.flattenFilterExpression(expr);
        }
        if (expression instanceof IConditionalExpression) {
            IScriptExpression expr = ((IConditionalExpression)expression).getExpression();
            IBaseExpression oprand1 = ((IConditionalExpression)expression).getOperand1();
            IBaseExpression oprand2 = ((IConditionalExpression)expression).getOperand2();
            return ExpressionCompilerUtil.isValidExpressionInQueryFilter(expr, context) && ExpressionCompilerUtil.isValidExpressionInQueryFilter(oprand1, context) && ExpressionCompilerUtil.isValidExpressionInQueryFilter(oprand2, context);
        }
        return true;
    }

    private static boolean compile(String expression, ExprManager exprManager, ScriptContext cx) throws DataException {
        AggregateRegistry aggrReg = new AggregateRegistry(){

            public int register(AggregateExpression aggregationExpr) {
                return -1;
            }
        };
        ExpressionCompiler expressionCompiler = new ExpressionCompiler();
        CompiledExpression expr = expressionCompiler.compile(expression, aggrReg, cx);
        return ExpressionCompilerUtil.flattenExpression(expr, exprManager, cx);
    }

    private static boolean flattenExpression(CompiledExpression expr, ExprManager exprManager, ScriptContext cx) throws DataException {
        int type = expr.getType();
        switch (type) {
            case 3: {
                Iterator col = ((ComplexExpression)expr).getSubExpressions().iterator();
                while (col.hasNext()) {
                    if (ExpressionCompilerUtil.flattenExpression((CompiledExpression)col.next(), exprManager, cx)) continue;
                    return false;
                }
                break;
            }
            case 1: {
                String columnName = ((ColumnReferenceExpression)expr).getColumnName();
                if ("__rownum".equals(columnName)) {
                    return true;
                }
                if (exprManager.getExpr(columnName) != null) {
                    String expression = ((IScriptExpression)exprManager.getExpr(columnName)).getText();
                    return ExpressionCompilerUtil.compile(expression, exprManager, cx);
                }
                return false;
            }
            case 2: {
                Iterator args = ((AggregateExpression)expr).getArguments().iterator();
                while (args.hasNext()) {
                    if (ExpressionCompilerUtil.flattenExpression((CompiledExpression)args.next(), exprManager, cx)) continue;
                    return false;
                }
                break;
            }
            case 4: 
            case 5: {
                return true;
            }
        }
        return true;
    }

    private static boolean flattenFilterExpression(CompiledExpression expr) throws DataException {
        int type = expr.getType();
        switch (type) {
            case 3: {
                Iterator col = ((ComplexExpression)expr).getSubExpressions().iterator();
                while (col.hasNext()) {
                    if (ExpressionCompilerUtil.flattenFilterExpression((CompiledExpression)col.next())) continue;
                    return false;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                int numberOfPasses = ((AggregateExpression)expr).getAggregation().getNumberOfPasses();
                if (numberOfPasses > 1) break;
                return false;
            }
            case 4: {
                break;
            }
            case 5: {
                throw (DataException)((InvalidExpression)expr).evaluate(null, null);
            }
        }
        return true;
    }

    private static void populateColumnList(List list, IBaseExpression expression, String indicator) throws DataException {
        if (expression != null) {
            List l = new ArrayList();
            try {
                if (expression instanceof IScriptExpression) {
                    l = ExpressionUtil.extractColumnExpressions(((IScriptExpression)expression).getText(), indicator);
                }
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            int i = 0;
            while (i < l.size()) {
                IColumnBinding cb = (IColumnBinding)l.get(i);
                if (!list.contains(cb.getResultSetColumnName()) && cb.getOuterLevel() == 0) {
                    list.add(cb.getResultSetColumnName());
                }
                ++i;
            }
        }
    }

    public static String getFirstFoundNameInCycle(Set<NamedExpression> namedExpressions, String indicator) {
        if (namedExpressions == null) {
            return null;
        }
        HashSet<DirectedGraphEdge> graphEdges = new HashSet<DirectedGraphEdge>();
        for (NamedExpression ne : namedExpressions) {
            List referenceNames = null;
            try {
                referenceNames = ExpressionCompilerUtil.extractColumnExpression(ne.getExpression(), indicator);
            }
            catch (DataException dataException) {}
            if (referenceNames == null) continue;
            for (String reference : referenceNames) {
                graphEdges.add(new DirectedGraphEdge(new GraphNode(ne.getName()), new GraphNode(reference)));
            }
        }
        DirectedGraph graph = new DirectedGraph(graphEdges);
        String foundName = null;
        try {
            graph.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            foundName = (String)e.getNode().getValue();
        }
        return foundName;
    }
}

