/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public class ResultSetItem
implements IResultSetItem {
    private String resultSetName;
    private IResultMetaData resultSetMetaData;
    private DesignElementHandle handle;
    private Locale locale;

    private ResultSetItem() {
    }

    public ResultSetItem(String resultSetName, IResultMetaData metaData) {
        this.resultSetName = resultSetName;
        this.resultSetMetaData = metaData;
    }

    public ResultSetItem(String resultSetName, IResultMetaData metaData, DesignElementHandle handle, Locale loc) {
        this.resultSetName = resultSetName;
        this.resultSetMetaData = metaData;
        this.handle = handle;
        this.locale = loc;
    }

    public String getResultSetName() {
        return this.resultSetName;
    }

    public IResultMetaData getResultMetaData() {
        return this.resultSetMetaData;
    }

    public String getResultSetDisplayName() {
        if (this.handle instanceof ReportElementHandle) {
            ReportElementHandle tmpHandle = (ReportElementHandle)this.handle;
            if (tmpHandle.getDisplayName() != null) {
                return ModuleUtil.getExternalizedValue(tmpHandle, tmpHandle.getDisplayNameKey(), tmpHandle.getDisplayName(), ULocale.forLocale((Locale)this.locale));
            }
        } else if (this.handle != null) {
            return ModuleUtil.getExternalizedValue(this.handle, this.handle.getName(), this.resultSetName, ULocale.forLocale((Locale)this.locale));
        }
        return this.resultSetName;
    }

    public DesignElementHandle getHandle() {
        return this.handle;
    }
}

