/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.SlotDefn;

public class ExtensionSlotDefn
extends SlotDefn {
    protected IMessages messages = null;
    protected String defaultDisplayName = null;

    public ExtensionSlotDefn(IMessages messages) {
        this.messages = messages;
    }

    public String getDefaultDisplayName() {
        return this.defaultDisplayName;
    }

    public void setDefaultDisplayName(String defaultDisplayName) {
        this.defaultDisplayName = defaultDisplayName;
    }

    public String getDisplayName() {
        String displayName;
        if (this.displayNameID != null && this.messages != null && !StringUtil.isBlank(displayName = this.messages.getMessage(this.displayNameID, ThreadResources.getLocale()))) {
            return displayName;
        }
        if (this.defaultDisplayName != null) {
            return this.defaultDisplayName;
        }
        return this.getName();
    }

    protected void build() throws MetaDataException {
        if (this.contentTypes.isEmpty()) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_SLOT_TYPE");
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        this.contentElements.clear();
        for (String name : this.contentTypes) {
            IElementDefn type = dd.getElement(name);
            if (type == null) {
                type = dd.getExtension(name);
            }
            if (type == null) {
                throw new MetaDataException(new String[]{name, this.name}, "INVALID_SLOT_TYPE");
            }
            this.contentElements.add(type);
        }
    }
}

