/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.sql;

import java.io.Serializable;
import org.hibernate.dialect.Dialect;

public class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int sqlType;
    private boolean primary;
    private boolean nullable = true;
    private String defaultValue;
    private int length = 255;
    private int precision = 19;
    private int scale = 2;

    public Column(String name, int sqlType) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.sqlType = sqlType;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return dialect.openQuote() + this.name + dialect.closeQuote();
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getSqlTypeString(Dialect dialect) {
        return dialect.getTypeName(this.sqlType, this.length, this.precision, this.scale);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.name + ')';
    }
}

