/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.seam;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.dam.seam.DamActions;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewState;
import org.nuxeo.ecm.platform.contentview.json.JSONContentViewState;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.webapp.action.MainTabsActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="damSearchActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DamSearchActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DamSearchActions.class);
    public static final String SAVED_SEARCHES_LABEL = "label.dam.saved.searches";
    public static final String SHARED_SEARCHES_LABEL = "label.dam.shared.searches";
    public static final String SEARCH_FILTERS_LABEL = "label.dam.search.filters";
    public static final String SEARCH_SAVED_LABEL = "label.dam.search.saved";
    public static final String DAM_FLAG = "DAM";
    public static final String DAM_CODEC = "docpathdam";
    public static final String CONTENT_VIEW_NAME_PARAMETER = "contentViewName";
    public static final String CURRENT_PAGE_PARAMETER = "currentPage";
    public static final String PAGE_SIZE_PARAMETER = "pageSize";
    public static final String CONTENT_VIEW_STATE_PARAMETER = "state";
    @In(create=true)
    protected DamActions damActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected MainTabsActions mainTabsActions;
    @In(create=true)
    protected RestHelper restHelper;
    @In(create=true)
    protected ContentViewActions contentViewActions;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected List<String> contentViewNames;
    protected Set<ContentViewHeader> contentViewHeaders;
    protected String currentContentViewName;
    protected String currentSelectedSavedSearchId;
    protected String currentPage;
    protected String pageSize;
    protected String savedSearchTitle;

    public String getCurrentContentViewName() {
        List<String> contentViewNames;
        if (this.currentContentViewName == null && !(contentViewNames = this.getContentViewNames()).isEmpty()) {
            this.currentContentViewName = contentViewNames.get(0);
        }
        return this.currentContentViewName;
    }

    public void setCurrentContentViewName(String contentViewName) throws ClientException {
        this.currentContentViewName = contentViewName;
    }

    public String getCurrentSelectedSavedSearchId() {
        return this.currentSelectedSavedSearchId != null ? this.currentSelectedSavedSearchId : this.currentContentViewName;
    }

    public void setCurrentSelectedSavedSearchId(String selectedSavedSearchId) throws ClientException {
        if (this.contentViewNames.contains(selectedSavedSearchId)) {
            this.contentViewActions.reset(this.currentContentViewName);
            this.currentContentViewName = selectedSavedSearchId;
            this.currentSelectedSavedSearchId = null;
        } else {
            DocumentModel savedSearch = this.documentManager.getDocument((DocumentRef)new IdRef(selectedSavedSearchId));
            String contentViewName = (String)((Object)savedSearch.getPropertyValue("cvd:contentViewName"));
            this.loadSavedSearch(contentViewName, savedSearch);
        }
        this.currentSelectedSavedSearchId = this.currentSelectedSavedSearchId;
    }

    public void loadSavedSearch(String contentViewName, DocumentModel searchDocument) throws ClientException {
        ContentView contentView = this.contentViewActions.getContentView(contentViewName, searchDocument);
        if (contentView != null) {
            this.currentContentViewName = contentViewName;
            this.currentSelectedSavedSearchId = searchDocument.getId();
        }
    }

    public List<String> getContentViewNames() {
        if (this.contentViewNames == null) {
            ContentViewService contentViewService = (ContentViewService)Framework.getLocalService(ContentViewService.class);
            this.contentViewNames = new ArrayList<String>(contentViewService.getContentViewNames(DAM_FLAG));
        }
        return this.contentViewNames;
    }

    public Set<ContentViewHeader> getContentViewHeaders() throws ClientException {
        if (this.contentViewHeaders == null) {
            this.contentViewHeaders = new HashSet<ContentViewHeader>();
            ContentViewService contentViewService = (ContentViewService)Framework.getLocalService(ContentViewService.class);
            for (String name : this.getContentViewNames()) {
                ContentViewHeader header = contentViewService.getContentViewHeader(name);
                if (header == null) continue;
                this.contentViewHeaders.add(header);
            }
        }
        return this.contentViewHeaders;
    }

    public void clearSearch() throws ClientException {
        this.contentViewActions.reset(this.getCurrentContentViewName());
        this.updateCurrentDocument();
    }

    @Observer(value={"refreshDamSearch"}, create=true)
    public void refreshAndRewind() throws ClientException {
        this.contentViewActions.refreshAndRewind(this.getCurrentContentViewName());
        this.updateCurrentDocument();
    }

    public void updateCurrentDocument() throws ClientException {
        ContentView contentView = this.contentViewActions.getContentView(this.getCurrentContentViewName());
        this.updateCurrentDocument((PageProvider<DocumentModel>)contentView.getCurrentPageProvider());
    }

    public void updateCurrentDocument(PageProvider<DocumentModel> pageProvider) throws ClientException {
        if (pageProvider == null) {
            return;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        List docs = pageProvider.getCurrentPage();
        if (docs.isEmpty()) {
            this.damActions.selectDocument(null);
        } else if (!docs.contains(currentDocument)) {
            this.damActions.selectDocument((DocumentModel)docs.get(0));
        }
    }

    public List<SelectItem> getAllSavedSearchesSelectItems() throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        SelectItemGroup userGroup = new SelectItemGroup(this.messages.get(SAVED_SEARCHES_LABEL));
        List<DocumentModel> userSavedSearches = this.getSavedSearches();
        List<SelectItem> userSavedSearchesItems = this.convertToSelectItems(userSavedSearches);
        userGroup.setSelectItems(userSavedSearchesItems.toArray(new SelectItem[userSavedSearchesItems.size()]));
        items.add((SelectItem)userGroup);
        List<DocumentModel> otherUsersSavedFacetedSearches = this.getSharedSearches();
        List<SelectItem> otherUsersSavedSearchesItems = this.convertToSelectItems(otherUsersSavedFacetedSearches);
        SelectItemGroup allGroup = new SelectItemGroup(this.messages.get(SHARED_SEARCHES_LABEL));
        allGroup.setSelectItems(otherUsersSavedSearchesItems.toArray(new SelectItem[otherUsersSavedSearchesItems.size()]));
        items.add((SelectItem)allGroup);
        SelectItemGroup flaggedGroup = new SelectItemGroup(this.messages.get(SEARCH_FILTERS_LABEL));
        Set<ContentViewHeader> flaggedSavedSearches = this.getContentViewHeaders();
        List<SelectItem> flaggedSavedSearchesItems = this.convertCVToSelectItems(flaggedSavedSearches);
        flaggedGroup.setSelectItems(flaggedSavedSearchesItems.toArray(new SelectItem[flaggedSavedSearchesItems.size()]));
        items.add((SelectItem)flaggedGroup);
        return items;
    }

    protected List<DocumentModel> getSavedSearches() throws ClientException {
        return this.getDocuments("SAVED_DAM_SEARCHES", this.documentManager.getPrincipal().getName());
    }

    protected List<DocumentModel> getSharedSearches() throws ClientException {
        return this.getDocuments("SHARED_DAM_SEARCHES", this.documentManager.getPrincipal().getName());
    }

    protected List<DocumentModel> getDocuments(String pageProviderName, Object ... parameters) throws ClientException {
        PageProviderService pageProviderService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("coreSession", (Serializable)this.documentManager);
        return pageProviderService.getPageProvider(pageProviderName, null, null, null, properties, parameters).getCurrentPage();
    }

    protected List<SelectItem> convertToSelectItems(List<DocumentModel> docs) throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (DocumentModel doc : docs) {
            items.add(new SelectItem((Object)doc.getId(), doc.getTitle(), ""));
        }
        return items;
    }

    protected List<SelectItem> convertCVToSelectItems(Set<ContentViewHeader> contentViewHeaders) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ContentViewHeader contentViewHeader : contentViewHeaders) {
            items.add(new SelectItem((Object)contentViewHeader.getName(), this.messages.get(contentViewHeader.getTitle()), ""));
        }
        return items;
    }

    public String getSavedSearchTitle() {
        return this.savedSearchTitle;
    }

    public void setSavedSearchTitle(String savedSearchTitle) {
        this.savedSearchTitle = savedSearchTitle;
    }

    public String saveSearch() throws ClientException {
        ContentView contentView = this.contentViewActions.getContentView(this.getCurrentContentViewName());
        if (contentView != null) {
            UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
            DocumentModel uws = userWorkspaceService.getCurrentUserPersonalWorkspace(this.documentManager, null);
            DocumentModel searchDoc = contentView.getSearchDocumentModel();
            searchDoc.setPropertyValue("cvd:contentViewName", (Serializable)((Object)contentView.getName()));
            searchDoc.setPropertyValue("dc:title", (Serializable)((Object)this.savedSearchTitle));
            PathSegmentService pathService = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
            searchDoc.setPathInfo(uws.getPathAsString(), pathService.generatePathSegment(searchDoc));
            searchDoc = this.documentManager.createDocument(searchDoc);
            this.documentManager.save();
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get(SEARCH_SAVED_LABEL), new Object[0]);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{uws});
            this.savedSearchTitle = null;
            this.currentSelectedSavedSearchId = searchDoc.getId();
        }
        return null;
    }

    public void setState(String state) throws ClientException, UnsupportedEncodingException {
        if (StringUtils.isNotBlank((String)state)) {
            Long finalPageSize = null;
            if (!StringUtils.isBlank((String)this.pageSize)) {
                try {
                    finalPageSize = Long.valueOf(this.pageSize);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)String.format("Unable to parse '%s' parameter with value '%s'", PAGE_SIZE_PARAMETER, this.pageSize));
                }
            }
            Long finalCurrentPage = null;
            if (!StringUtils.isBlank((String)this.currentPage)) {
                try {
                    finalCurrentPage = Long.valueOf(this.currentPage);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)String.format("Unable to parse '%s' parameter with value '%s'", CURRENT_PAGE_PARAMETER, this.currentPage));
                }
            }
            this.contentViewActions.restoreContentView(this.getCurrentContentViewName(), finalCurrentPage, finalPageSize, null, state);
        }
        this.updateCurrentDocument();
    }

    public String getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(String currentPage) {
        this.currentPage = currentPage;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String getSearchPermanentLinkUrl() throws ClientException, UnsupportedEncodingException {
        String currentContentViewName = this.getCurrentContentViewName();
        DocumentModel damCurrentDocument = this.mainTabsActions.getDocumentFor("dam");
        DocumentView docView = this.computeDocumentView(damCurrentDocument);
        docView.setViewId("assets");
        docView.addParameter(CONTENT_VIEW_NAME_PARAMETER, currentContentViewName);
        ContentView contentView = this.contentViewActions.getContentView(currentContentViewName);
        ContentViewService contentViewService = (ContentViewService)Framework.getLocalService(ContentViewService.class);
        ContentViewState state = contentViewService.saveContentView(contentView);
        docView.addParameter(CONTENT_VIEW_STATE_PARAMETER, JSONContentViewState.toJSON((ContentViewState)state, (boolean)true));
        DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
        String url = documentViewCodecManager.getUrlFromDocumentView(DAM_CODEC, docView, true, BaseURL.getBaseURL());
        return RestHelper.addCurrentConversationParameters((String)url);
    }

    protected DocumentView computeDocumentView(DocumentModel doc) {
        if (doc != null) {
            return new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(this.documentManager.getRepositoryName(), (DocumentRef)new PathRef(doc.getPathAsString())));
        }
        return new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(this.documentManager.getRepositoryName(), null));
    }

    public String getAssetPermanentLinkUrl() throws ClientException, UnsupportedEncodingException {
        DocumentModel damCurrentDocument = this.mainTabsActions.getDocumentFor("dam");
        DocumentView docView = this.computeDocumentView(damCurrentDocument);
        docView.setViewId("asset");
        DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
        return documentViewCodecManager.getUrlFromDocumentView(DAM_CODEC, docView, true, BaseURL.getBaseURL());
    }

    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public String loadPermanentLink(DocumentView docView) throws ClientException {
        this.restHelper.initContextFromRestRequest(docView);
        return "assets";
    }

    @Observer(value={"contentViewPageChanged", "contentViewPageSizeChanged", "contentViewRefresh"}, create=true)
    public void onContentViewPageProviderChanged(String contentViewName) throws ClientException {
        String currentContentViewName = this.getCurrentContentViewName();
        if (currentContentViewName != null && currentContentViewName.equals(contentViewName)) {
            String viewId;
            if (FacesContext.getCurrentInstance() == null) {
                return;
            }
            UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
            if (viewRoot != null && "/dam/assets.xhtml".equals(viewId = viewRoot.getViewId())) {
                this.updateCurrentDocument();
            }
        }
    }
}

