/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.quasiliteral.QuasiNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleQuasiNode
extends QuasiNode {
    private final Class<? extends ParseTreeNode> clazz;
    private final Object value;

    protected SimpleQuasiNode(Class<? extends ParseTreeNode> clazz, Object value, QuasiNode ... children) {
        super(children);
        this.clazz = clazz;
        this.value = value;
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        if (specimens.isEmpty()) {
            return false;
        }
        if (this.matchSelf(specimens.get(0)) && this.matchChildren(specimens.get(0), bindings)) {
            specimens.remove(0);
            return true;
        }
        return false;
    }

    private boolean matchSelf(ParseTreeNode specimen) {
        return this.clazz == specimen.getClass() && SimpleQuasiNode.safeEquals(this.value, specimen.getValue());
    }

    private boolean matchChildren(ParseTreeNode specimen, Map<String, ParseTreeNode> bindings) {
        ArrayList<ParseTreeNode> specimenChildren = new ArrayList<ParseTreeNode>();
        specimenChildren.addAll(specimen.children());
        for (QuasiNode child : this.getChildren()) {
            if (child.consumeSpecimens(specimenChildren, bindings)) continue;
            return false;
        }
        return specimenChildren.size() == 0;
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        ArrayList<ParseTreeNode> children = new ArrayList<ParseTreeNode>();
        for (QuasiNode child : this.getChildren()) {
            if (child.createSubstitutes(children, bindings)) continue;
            return false;
        }
        ParseTreeNode node = ParseTreeNodes.newNodeInstance(this.clazz, FilePosition.UNKNOWN, this.value, children);
        substitutes.add(node);
        return true;
    }

    public Class<? extends ParseTreeNode> getMatchedClass() {
        return this.clazz;
    }

    public String toString() {
        return this.clazz.getSimpleName() + (this.value == null ? "" : " : " + this.value);
    }
}

