/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Operand;

public class Reference
implements Operand {
    private static final long serialVersionUID = -1725102431543210429L;
    public final String name;
    public final String cast;

    public Reference(String name) {
        this.name = name;
        this.cast = null;
    }

    public Reference(String name, String cast) {
        this.name = name;
        this.cast = cast;
    }

    public Reference(Reference other, String cast) {
        this.name = other.name;
        this.cast = cast;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitReference(this);
    }

    public String toString() {
        if (this.cast == null) {
            return this.name;
        }
        return this.cast + '(' + this.name + ')';
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        return this.equals((Reference)obj);
    }

    private boolean equals(Reference other) {
        return this.name.equals(other.name) && StringUtils.equals((String)this.cast, (String)other.cast);
    }

    public int hashCode() {
        int result = 31 + (this.cast == null ? 0 : this.cast.hashCode());
        return 31 * result + this.name.hashCode();
    }

    public boolean isPathReference() {
        return false;
    }
}

