/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.io.Serializable;
import java.security.Principal;
import org.nuxeo.ecm.core.query.sql.model.ASTNode;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.GroupByClause;
import org.nuxeo.ecm.core.query.sql.model.HavingClause;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;

public class SQLQuery
implements ASTNode {
    private static final long serialVersionUID = 6383829486216039408L;
    private String queryString;
    public SelectClause select;
    public final FromClause from;
    public final WhereClause where;
    public final OrderByClause orderBy;
    public final GroupByClause groupBy;
    public final HavingClause having;
    public long limit = 0L;
    public long offset = 0L;

    public SQLQuery() {
        this(new SelectClause(), new FromClause(), null, null, null, null);
    }

    public SQLQuery(SelectClause select, FromClause from) {
        this(select, from, null, null, null, null);
    }

    public SQLQuery(SelectClause select, FromClause from, WhereClause where) {
        this(select, from, where, null, null, null);
    }

    public SQLQuery(SelectClause select, FromClause from, WhereClause where, OrderByClause orderBy) {
        this(select, from, where, null, null, orderBy);
    }

    public SQLQuery(SelectClause select, FromClause from, WhereClause where, GroupByClause groupBy, HavingClause having, OrderByClause orderBy) {
        assert (select != null && from != null);
        this.select = select;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
    }

    public SQLQuery(SelectClause select, FromClause from, WhereClause where, GroupByClause groupBy, HavingClause having, OrderByClause orderBy, long limit, long offset) {
        assert (select != null && from != null);
        this.select = select;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
    }

    public SQLQuery(SQLQuery other) {
        this.select = other.select;
        this.from = other.from;
        this.where = other.where;
        this.orderBy = other.orderBy;
        this.groupBy = other.groupBy;
        this.having = other.having;
        this.limit = other.limit;
        this.offset = other.offset;
    }

    public SelectClause getSelectClause() {
        return this.select;
    }

    public FromClause getFromClause() {
        return this.from;
    }

    public WhereClause getWhereClause() {
        return this.where;
    }

    public OrderByClause getOrderByClause() {
        return this.orderBy;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitQuery(this);
    }

    public String toString() {
        if (this.queryString != null) {
            return this.queryString;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(this.select).append(" FROM ").append(this.from);
        if (this.where != null) {
            buf.append(" WHERE ").append(this.where);
        }
        if (this.orderBy != null) {
            buf.append(" ORDER BY ").append(this.orderBy);
        }
        return buf.toString();
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLQuery other = (SQLQuery)obj;
        if (this.select == null ? other.select != null : !this.select.equals(other.select)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.where == null ? other.where != null : !this.where.equals(other.where)) {
            return false;
        }
        if (this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy)) {
            return false;
        }
        if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
            return false;
        }
        if (this.having == null ? other.having != null : !this.having.equals(other.having)) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        return this.offset == other.offset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.select == null ? 0 : this.select.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.where == null ? 0 : this.where.hashCode());
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = 31 * result + (this.groupBy == null ? 0 : this.groupBy.hashCode());
        result = 31 * result + (this.having == null ? 0 : this.having.hashCode());
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    public static class IdentityTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;

        @Override
        public SQLQuery transform(Principal principal, SQLQuery query) {
            return query;
        }
    }

    public static interface Transformer
    extends Serializable {
        public static final Transformer IDENTITY = new IdentityTransformer();

        public SQLQuery transform(Principal var1, SQLQuery var2);
    }
}

