/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationFragment;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ApplicationManager
implements BundleTrackerCustomizer {
    private static final Log log = LogFactory.getLog(ApplicationManager.class);
    public static final String HOST_ATTR = "host";
    public static final String DEFAULT_HOST = "default";
    private static final ApplicationManager instance = new ApplicationManager();
    protected BundleTracker tracker;
    protected Map<String, ApplicationHost> apps;

    public static ApplicationManager getInstance() {
        return instance;
    }

    public synchronized void start(BundleContext context) {
        this.apps = new HashMap<String, ApplicationHost>();
        this.tracker = new BundleTracker(context, 44, (BundleTrackerCustomizer)this);
        this.tracker.open();
    }

    public synchronized void stop(BundleContext context) {
        this.tracker.close();
        this.tracker = null;
        this.apps = null;
    }

    public synchronized ApplicationHost getOrCreateApplication(String name) {
        ApplicationHost host = this.apps.get(name);
        if (host == null) {
            host = new ApplicationHost(name);
            this.apps.put(name, host);
        }
        return host;
    }

    public synchronized ApplicationHost getApplication(String name) {
        return this.apps.get(name);
    }

    public synchronized ApplicationHost getApplication(ApplicationFragment fragment) {
        String host = fragment.getHostName();
        return this.apps.get(host);
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        String v = (String)bundle.getHeaders().get("Nuxeo-WebModule");
        if (v != null) {
            String classRef = null;
            HashMap<String, String> vars = new HashMap();
            String varsStr = null;
            int i = v.indexOf(59);
            if (i > -1) {
                classRef = v.substring(0, i).trim();
                varsStr = v.substring(i + 1).trim();
            } else {
                classRef = v.trim();
            }
            if (varsStr != null) {
                vars = this.parseAttrs(varsStr);
            }
            try {
                ApplicationFragment fragment = new ApplicationFragment(bundle, classRef, vars);
                ApplicationHost app = this.getOrCreateApplication(fragment.getHostName());
                app.add(fragment);
                app.reload();
                return fragment;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        ApplicationHost app;
        ApplicationFragment fragment;
        if (event.getType() == 8 && (fragment = (ApplicationFragment)((Object)object)) != null && (app = this.getApplication(fragment)) != null) {
            try {
                app.reload();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        ApplicationHost app;
        ApplicationFragment fragment = (ApplicationFragment)((Object)object);
        if (fragment != null && (app = this.getApplication(fragment)) != null) {
            app.remove(fragment);
            try {
                app.reload();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected Map<String, String> parseAttrs(String expr) {
        String[] ar;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String a : ar = StringUtils.split((String)expr, (char)';', (boolean)true)) {
            int i = a.indexOf(61);
            if (i == -1) {
                map.put(a, null);
                continue;
            }
            String key = a.substring(0, i).trim();
            String val = a.substring(i + 1).trim();
            if (key.endsWith(":")) {
                key = key.substring(0, key.length() - 1).trim();
            }
            map.put(key, val);
        }
        return map;
    }
}

