/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ws;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.ws.WSEndpointDescriptor;
import org.nuxeo.ecm.platform.ws.WSEndpointManager;
import org.nuxeo.ecm.platform.ws.WSEndpointRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class WSEndpointManagerImpl
extends DefaultComponent
implements WSEndpointManager {
    public static final String ENDPOINT_EP = "endpoint";
    private static final Log log = LogFactory.getLog(WSEndpointManagerImpl.class);
    private static final int APPLICATION_STARTED_ORDER = 1500;
    protected WSEndpointRegistry regitry = new WSEndpointRegistry();
    protected Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ENDPOINT_EP.equals(extensionPoint)) {
            this.regitry.addContribution((WSEndpointDescriptor)contribution);
        } else {
            log.info((Object)("Unknown extension point: " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ENDPOINT_EP.equals(extensionPoint)) {
            WSEndpointDescriptor descriptor = (WSEndpointDescriptor)contribution;
            this.stopIfExists(descriptor.name);
            this.regitry.removeContribution(descriptor);
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        for (Endpoint ep : this.endpoints.values()) {
            ep.stop();
        }
        this.endpoints.clear();
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        if (!Framework.isTestModeSet()) {
            this.publishEndpoints();
        }
    }

    @Override
    public void publishEndpoints() {
        for (WSEndpointDescriptor desc : this.regitry.getContributions()) {
            try {
                this.stopIfExists(desc.name);
                Endpoint ep = desc.toEndpoint();
                ep.publish(desc.address);
                desc.configurePostPublishing(ep);
                if (ep.isPublished()) {
                    this.endpoints.put(desc.name, ep);
                    continue;
                }
                log.warn((Object)("Endpoint publishing is failing: " + desc.name));
            }
            catch (IOException | IllegalAccessException | InstantiationException e) {
                log.warn((Object)("Unable to register endpoint: " + desc.name), (Throwable)e);
            }
        }
    }

    @Override
    public Collection<WSEndpointDescriptor> getDescriptors() {
        return this.regitry.getContributions();
    }

    protected void stopIfExists(String name) {
        Endpoint ep = this.endpoints.get(name);
        if (ep != null) {
            ep.stop();
            this.endpoints.remove(name);
        }
    }

    public int getApplicationStartedOrder() {
        return 1500;
    }
}

