/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandlerDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class PostContentCreationHandlerRegistry
extends ContributionFragmentRegistry<PostContentCreationHandlerDescriptor> {
    private static final Log log = LogFactory.getLog(PostContentCreationHandlerRegistry.class);
    protected Map<String, PostContentCreationHandlerDescriptor> postContentCreationHandlerDescriptors = new HashMap<String, PostContentCreationHandlerDescriptor>();

    public String getContributionId(PostContentCreationHandlerDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, PostContentCreationHandlerDescriptor contrib, PostContentCreationHandlerDescriptor newOrigContrib) {
        if (contrib.isEnabled()) {
            this.postContentCreationHandlerDescriptors.put(id, contrib);
        } else {
            this.postContentCreationHandlerDescriptors.remove(id);
        }
    }

    public void contributionRemoved(String id, PostContentCreationHandlerDescriptor contrib) {
        this.postContentCreationHandlerDescriptors.remove(id);
    }

    public PostContentCreationHandlerDescriptor clone(PostContentCreationHandlerDescriptor postContentCreationHandler) {
        try {
            return (PostContentCreationHandlerDescriptor)postContentCreationHandler.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void merge(PostContentCreationHandlerDescriptor src, PostContentCreationHandlerDescriptor dst) {
        int order;
        if (src.getClazz() != null) {
            dst.setClazz(src.getClazz());
        }
        if (src.isEnabled() != dst.isEnabled()) {
            dst.setEnabled(src.isEnabled());
        }
        if ((order = src.getOrder()) > 0 && order != dst.getOrder()) {
            dst.setOrder(src.getOrder());
        }
    }

    public List<PostContentCreationHandler> getOrderedHandlers() {
        ArrayList<PostContentCreationHandlerDescriptor> descs = new ArrayList<PostContentCreationHandlerDescriptor>(this.postContentCreationHandlerDescriptors.values());
        Collections.sort(descs);
        ArrayList<PostContentCreationHandler> handlers = new ArrayList<PostContentCreationHandler>();
        for (PostContentCreationHandlerDescriptor desc : descs) {
            try {
                handlers.add(desc.getClazz().newInstance());
            }
            catch (Exception e) {
                log.error((Object)("Unable to instantiate class for handler: " + desc.getName()), (Throwable)e);
            }
        }
        return handlers;
    }
}

