/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.doc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.automation.io.yaml.YamlWriter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="doc")
@Produces(value={"text/html;charset=UTF-8"})
public class DocResource
extends AbstractResource<ResourceTypeImpl> {
    private final Log log = LogFactory.getLog(DocResource.class);
    protected AutomationService service;
    protected List<OperationDocumentation> ops;

    public void initialize(Object ... args) {
        try {
            this.service = (AutomationService)Framework.getLocalService(AutomationService.class);
            this.ops = this.service.getDocumentation();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to get automation service", (Throwable)e);
            throw WebException.wrap((Throwable)e);
        }
    }

    protected Template getTemplateFor(String browse) {
        return this.getTemplateView("index").arg("browse", (Object)browse);
    }

    protected Template getTemplateView(String name) {
        HashMap<String, ArrayList<OperationDocumentation>> cats = new HashMap<String, ArrayList<OperationDocumentation>>();
        for (OperationDocumentation op : this.ops) {
            ArrayList<OperationDocumentation> list = (ArrayList<OperationDocumentation>)cats.get(op.getCategory());
            if (list == null) {
                list = new ArrayList<OperationDocumentation>();
                cats.put(op.getCategory(), list);
            }
            list.add(op);
        }
        ArrayList catNames = new ArrayList();
        catNames.addAll(cats.keySet());
        Collections.sort(catNames);
        LinkedHashMap scats = new LinkedHashMap();
        for (String catName : catNames) {
            scats.put(catName, cats.get(catName));
        }
        return this.getView(name).arg("categories", scats).arg("operations", this.ops);
    }

    @GET
    public Object doGet(@QueryParam(value="id") String id, @QueryParam(value="browse") String browse) {
        if (id == null) {
            return this.getTemplateFor(browse);
        }
        OperationDocumentation opDoc = null;
        for (OperationDocumentation op : this.ops) {
            if (!op.getId().equals(id)) continue;
            opDoc = op;
            break;
        }
        if (opDoc == null) {
            throw new WebApplicationException(Response.status((int)404).build());
        }
        Template tpl = this.getTemplateFor(browse);
        tpl.arg("operation", opDoc);
        CoreSession session = SessionFactory.getSession();
        if (((NuxeoPrincipal)session.getPrincipal()).isAdministrator()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                YamlWriter.toYaml((OutputStream)out, (OperationDocumentation)opDoc);
                tpl.arg("yaml", (Object)out.toString());
            }
            catch (IOException e) {
                throw WebException.wrap((Throwable)e);
            }
        }
        return tpl;
    }

    protected boolean canManageTraces() {
        return ((NuxeoPrincipal)WebEngine.getActiveContext().getPrincipal()).isAdministrator();
    }

    @GET
    @Path(value="/wiki")
    public Object doGetWiki() {
        return this.getTemplateView("wiki");
    }

    public boolean isTraceEnabled() {
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        return tracerFactory.getRecordingState();
    }

    @GET
    @Path(value="/toggleTraces")
    public Object toggleTraces() throws Exception {
        if (!this.canManageTraces()) {
            return "You can not manage traces";
        }
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        tracerFactory.toggleRecording();
        HttpServletRequest request = RequestContext.getActiveContext().getRequest();
        String url = request.getHeader("Referer");
        return Response.seeOther((URI)new URI(url)).build();
    }

    @GET
    @Path(value="/traces")
    @Produces(value={"text/plain"})
    public String doGetTrace(@QueryParam(value="opId") String opId) {
        if (!this.canManageTraces()) {
            return "You can not manage traces";
        }
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        Trace trace = tracerFactory.getTrace(opId);
        if (trace != null) {
            return tracerFactory.getTrace(opId).getFormattedText();
        }
        return "no trace";
    }

    public String[] getInputs(OperationDocumentation op) {
        if (op == null) {
            throw new IllegalArgumentException("Operation must not be null");
        }
        if (op.signature == null || op.signature.length == 0) {
            return new String[0];
        }
        String[] result = new String[op.signature.length / 2];
        int i = 0;
        int k = 0;
        while (i < op.signature.length) {
            result[k] = op.signature[i];
            i += 2;
            ++k;
        }
        return result;
    }

    public String[] getOutputs(OperationDocumentation op) {
        if (op == null) {
            throw new IllegalArgumentException("Operation must not be null");
        }
        if (op.signature == null || op.signature.length == 0) {
            return new String[0];
        }
        String[] result = new String[op.signature.length / 2];
        int i = 1;
        int k = 0;
        while (i < op.signature.length) {
            result[k] = op.signature[i];
            i += 2;
            ++k;
        }
        return result;
    }

    public String getInputsAsString(OperationDocumentation op) {
        Object[] result = this.getInputs(op);
        if (result == null || result.length == 0) {
            return "void";
        }
        return StringUtils.join((Object[])result, (String)", ");
    }

    public String getOutputsAsString(OperationDocumentation op) {
        Object[] result = this.getOutputs(op);
        if (result == null || result.length == 0) {
            return "void";
        }
        return StringUtils.join((Object[])result, (String)", ");
    }

    public String getParamDefaultValue(OperationDocumentation.Param param) {
        if (param.values != null && param.values.length > 0) {
            return StringUtils.join((Object[])param.values, (String)", ");
        }
        return "";
    }

    public boolean hasOperation(OperationDocumentation op) {
        if (op == null) {
            throw new IllegalArgumentException("Operation must not be null");
        }
        return op.getOperations() != null && op.getOperations().length != 0;
    }
}

