/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.cache.ThreadSafeCacheHolder;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.action.ConversionAction;
import org.nuxeo.runtime.api.Framework;

@Name(value="conversionActions")
@Scope(value=ScopeType.EVENT)
public class ConversionActionBean
implements ConversionAction {
    private static final Log log = LogFactory.getLog(ConversionActionBean.class);
    protected Map<String, ConverterCheckResult> pdfConverterForTypes;
    protected static final String PDF_MIMETYPE = "application/pdf";
    @In(create=true, required=false)
    CoreSession documentManager;
    @In(create=true)
    NavigationContext navigationContext;
    @RequestParameter
    private String docRef;
    @RequestParameter
    private String fileFieldFullName;
    @RequestParameter
    private String filename;
    protected String pdfConverterName;
    protected static final ThreadSafeCacheHolder<Boolean> exportableToPDFCache = new ThreadSafeCacheHolder(20);

    public String display() {
        return "view_file";
    }

    private DocumentModel getDocument() throws ClientException {
        if (this.docRef == null) {
            return this.navigationContext.getCurrentDocument();
        }
        return this.documentManager.getDocument((DocumentRef)new IdRef(this.docRef));
    }

    private String getMimetypeFromDocument(String propertyName) throws ClientException {
        Blob blob = (Blob)this.getDocument().getPropertyValue(propertyName);
        return blob.getMimeType();
    }

    @Override
    public void reCheckConverterAvailability() {
        this.pdfConverterForTypes.clear();
    }

    public boolean isExportableToPDF(BlobHolder bh) throws ClientException {
        if (bh == null) {
            return false;
        }
        Blob blob = bh.getBlob();
        if (blob == null) {
            return false;
        }
        return this.isExportableToPDF(blob);
    }

    @Override
    public boolean isExportableToPDF(Blob blob) {
        if (blob == null) {
            return false;
        }
        String mimetype = blob.getMimeType();
        return this.isMimeTypeExportableToPDF(mimetype);
    }

    protected boolean isMimeTypeExportableToPDF(String mimetype) {
        if (mimetype == null) {
            return false;
        }
        if (this.pdfConverterForTypes == null) {
            this.pdfConverterForTypes = new HashMap<String, ConverterCheckResult>();
        }
        if (this.pdfConverterForTypes.containsValue(mimetype)) {
            return this.pdfConverterForTypes.get(mimetype).isAvailable();
        }
        try {
            ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
            for (String this.pdfConverterName : conversionService.getConverterNames(mimetype, PDF_MIMETYPE)) {
                ConverterCheckResult pdfConverterAvailability = conversionService.isConverterAvailable(this.pdfConverterName, true);
                for (String supMimeType : pdfConverterAvailability.getSupportedInputMimeTypes()) {
                    this.pdfConverterForTypes.put(supMimeType, pdfConverterAvailability);
                }
                if (!pdfConverterAvailability.isAvailable()) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while testing PDF converter availability", (Throwable)e);
        }
        return false;
    }

    @Override
    @WebRemote
    public boolean isFileExportableToPDF(String fieldName) {
        try {
            boolean isSupported;
            DocumentModel doc = this.getDocument();
            Boolean cacheResult = (Boolean)exportableToPDFCache.getFromCache(doc, fieldName);
            if (cacheResult == null) {
                String mimetype = this.getMimetypeFromDocument(fieldName);
                isSupported = this.isMimeTypeExportableToPDF(mimetype);
                exportableToPDFCache.addToCache(doc, fieldName, (Serializable)Boolean.valueOf(isSupported));
            } else {
                isSupported = cacheResult;
            }
            return isSupported;
        }
        catch (Exception e) {
            log.error((Object)"Error while trying to check PDF conversion against a filename", (Throwable)e);
            return false;
        }
    }

    public String generatePdfFileFromBlobHolder(BlobHolder bh) {
        try {
            int pos;
            if (this.pdfConverterName == null) {
                log.error((Object)"No PDF converter was found.");
                return "pdf_generation_error";
            }
            BlobHolder result = ((ConversionService)Framework.getLocalService(ConversionService.class)).convert(this.pdfConverterName, bh, null);
            if (result == null) {
                log.error((Object)"Transform service didn't return any resulting documents which is not normal.");
                return "pdf_generation_error";
            }
            String origFilename = new Path(bh.getFilePath()).lastSegment();
            String filename = FileUtils.getCleanFileName((String)origFilename);
            if (StringUtils.isBlank((String)filename)) {
                filename = "file";
            }
            if ((pos = filename.lastIndexOf(46)) > 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + ".pdf";
            return ComponentUtils.download((FacesContext)FacesContext.getCurrentInstance(), (Blob)result.getBlob(), (String)filename);
        }
        catch (Exception e) {
            log.error((Object)("PDF generation error for file " + this.filename), (Throwable)e);
            return "pdf_generation_error";
        }
    }

    @Override
    @WebRemote
    public String generatePdfFile() {
        try {
            DocumentBlobHolder bh = new DocumentBlobHolder(this.getDocument(), this.fileFieldFullName);
            return this.generatePdfFileFromBlobHolder((BlobHolder)bh);
        }
        catch (Exception e) {
            log.error((Object)("PDF generation error for file " + this.filename), (Throwable)e);
            return "pdf_generation_error";
        }
    }

    public void initialize() {
    }
}

