/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.security.PermissionActionListManager;
import org.nuxeo.ecm.webapp.security.PermissionListManager;
import org.nuxeo.ecm.webapp.security.PrincipalListManager;
import org.nuxeo.ecm.webapp.security.SecurityData;

@Name(value="massSecurityModifierActions")
@Scope(value=ScopeType.CONVERSATION)
public class MassSecurityModifierActions
implements Serializable {
    private static final long serialVersionUID = 4978984433628773791L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    private Boolean blockRightInheritance;
    @In(create=true)
    private PermissionActionListManager permissionActionListManager;
    @In(create=true)
    private PermissionListManager permissionListManager;
    @In(create=true)
    private PrincipalListManager principalListManager;
    private final SecurityData securityData = null;

    public Boolean getBlockRightInheritance() {
        return this.blockRightInheritance;
    }

    public void setBlockRightInheritance(Boolean blockRightInheritance) {
        this.blockRightInheritance = blockRightInheritance;
    }

    public String applySecurity(String listName) throws ClientException {
        List docs2Modify = this.documentsListsManager.getWorkingList(listName);
        boolean nbModifiedDocs = false;
        for (DocumentModel doc : docs2Modify) {
            if (this.documentManager.hasPermission(doc.getParentRef(), "WriteProperties")) continue;
        }
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
    }
}

