/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import java.util.Calendar;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionManagerImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionFactoryImpl;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoContainer;

public class ConnectionFactoryImpl
implements Repository,
org.nuxeo.ecm.core.model.Repository {
    private static final long serialVersionUID = 1L;
    private final ManagedConnectionFactoryImpl managedConnectionFactory;
    private final ConnectionManager connectionManager;
    private final String name;
    private Reference reference;
    private final boolean managed;

    public ConnectionFactoryImpl(ManagedConnectionFactoryImpl managedConnectionFactory, ConnectionManager connectionManager) {
        this.managedConnectionFactory = managedConnectionFactory;
        this.connectionManager = connectionManager;
        this.managed = !(connectionManager instanceof ConnectionManagerImpl);
        this.name = managedConnectionFactory.getName();
    }

    public ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public Session getConnection(ConnectionSpec connectionSpec) throws StorageException {
        return this.getConnection();
    }

    public Session getConnection() throws StorageException {
        try {
            return (Session)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, null);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (ResourceException e) {
            String msg = e.getMessage();
            if (msg != null && msg.startsWith("No ManagedConnections available")) {
                String err = "Connection pool is fully used";
                if (this.connectionManager instanceof NuxeoContainer.ConnectionManagerWrapper) {
                    NuxeoContainer.ConnectionManagerWrapper cmw = (NuxeoContainer.ConnectionManagerWrapper)this.connectionManager;
                    NuxeoConnectionManagerConfiguration config = cmw.getConfiguration();
                    err = err + ", consider increasing " + "nuxeo.vcs.blocking-timeout-millis (currently " + config.getBlockingTimeoutMillis() + ") or " + "nuxeo.vcs.max-pool-size (currently " + config.getMaxPoolSize() + ")";
                }
                throw new StorageException(err, (Throwable)e);
            }
            throw new StorageException((Throwable)e);
        }
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public void close() throws StorageException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getName() {
        return this.name;
    }

    public org.nuxeo.ecm.core.model.Session getSession(String sessionId) throws DocumentException {
        try {
            return new SQLSession(this.getConnection(), (org.nuxeo.ecm.core.model.Repository)this, sessionId);
        }
        catch (StorageException e) {
            throw new DocumentException(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        try {
            NuxeoContainer.disposeConnectionManager((ConnectionManager)this.connectionManager);
        }
        catch (Exception e) {
            LogFactory.getLog(ConnectionFactoryImpl.class).warn((Object)("cannot dispose connection manager of " + this.name));
        }
        try {
            this.managedConnectionFactory.shutdown();
        }
        catch (StorageException e) {
            LogFactory.getLog(ConnectionFactoryImpl.class).warn((Object)("cannot shutdown connection factory  " + this.name));
        }
    }

    public int getActiveSessionsCount() {
        return this.managedConnectionFactory.getActiveSessionsCount();
    }

    public long getCacheSize() {
        return this.managedConnectionFactory.getCacheSize();
    }

    public long getCachePristineSize() {
        return this.managedConnectionFactory.getCachePristineSize();
    }

    public long getCacheSelectionSize() {
        return this.managedConnectionFactory.getCacheSelectionSize();
    }

    public int clearCaches() {
        return this.managedConnectionFactory.clearCaches();
    }

    public void processClusterInvalidationsNext() {
        this.managedConnectionFactory.processClusterInvalidationsNext();
    }

    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.managedConnectionFactory.getBinaryGarbageCollector();
    }

    public void markReferencedBinaries(BinaryGarbageCollector gc) {
        this.managedConnectionFactory.markReferencedBinaries(gc);
    }

    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        return this.managedConnectionFactory.cleanupDeletedDocuments(max, beforeTime);
    }
}

